/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.concurrent;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.InlineEditActionMessage;
import com.alibabacloud.intellij.cosy.editor.action.InlineEditActionDispatcher;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class InlineEditActionProcessor {
    public static final InlineEditActionProcessor INSTANCE = new InlineEditActionProcessor();
    private static final Logger log = Logger.getInstance(InlineEditActionProcessor.class);
    private final BlockingQueue<InlineEditActionMessage> messageQueue = new LinkedBlockingQueue<InlineEditActionMessage>();
    private final Lock lock = new ReentrantLock();
    private final Condition userActionCondition = this.lock.newCondition();
    private volatile boolean waitingForUserAction = false;
    private volatile boolean needConsume = true;
    private volatile boolean shutdown = false;
    private final InlineEditActionDispatcher dispatcher = new InlineEditActionDispatcher();

    private InlineEditActionProcessor() {
        this.startConsumerThread();
    }

    public void offerMessage(InlineEditActionMessage message) {
        if (message == null) {
            log.warn("Received null message, ignoring");
            return;
        }
        try {
            boolean offered = this.messageQueue.offer(message);
            if (!offered) {
                log.warn("Message queue is full, dropping message: " + message);
            }
        }
        catch (Exception e) {
            log.warn("offer message failed", (Throwable)e);
        }
    }

    public void triggerNextConsumption(boolean needConsume) {
        this.lock.lock();
        try {
            if (this.waitingForUserAction) {
                this.waitingForUserAction = false;
                this.needConsume = needConsume;
                this.userActionCondition.signalAll();
            } else {
                log.debug("No consumer waiting for user action");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startConsumerThread() {
        Thread consumerThread = new Thread(() -> {
            log.info("Consumer thread started");
            while (!Thread.currentThread().isInterrupted() && !this.shutdown) {
                try {
                    if (this.needConsume) {
                        InlineEditActionMessage message = this.messageQueue.take();
                        try {
                            this.dispatcher.dispatch(message);
                        }
                        catch (Exception e) {
                            log.warn("Error processing message: " + message, (Throwable)e);
                        }
                    } else {
                        this.messageQueue.clear();
                    }
                    this.waitForUserAction();
                }
                catch (InterruptedException e) {
                    log.warn("Consumer thread interrupted, exiting");
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    log.warn("Unexpected error in consumer thread", (Throwable)e);
                }
            }
        }, "InlineEditActionProcessor-Thread");
        consumerThread.start();
    }

    private void waitForUserAction() throws InterruptedException {
        this.lock.lock();
        try {
            this.waitingForUserAction = true;
            while (this.waitingForUserAction && !this.shutdown) {
                this.userActionCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

