/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.completion.trigger;

import com.alibabacloud.intellij.cosy.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.cosy.completion.trigger.TriggerCheckerAdapter;
import com.alibabacloud.intellij.cosy.util.DocumentUtils;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ValidInlineEditCommandTriggerChecker
extends TriggerCheckerAdapter {
    private static final Logger LOG = Logger.getInstance(ValidInlineEditCommandTriggerChecker.class);
    private static final Set<String> ALLOW_INLINE_EDIT_FORCE_COMMANDS = Set.of("Paste", "\u64a4\u6d88\u7c98\u8d34", "Backspace", "\u9000\u683c", "\u7c98\u8d34", "\u91cd\u505a\u7c98\u8d34", "VimEditorBackSpace", "VimDeleteMotionAction", "VimDeleteCharacterRightAction", "VimDeleteCharacterLeftAction", "VimPutTextAfterCursorAction", "VimPutTextBeforeCursorAction", "VimDeleteVisualAction");
    private static final Set<String> BACKSPACE_COMMANDS = Set.of("Backspace", "\u9000\u683c", "VimEditorBackSpace", "VimDeleteMotionAction", "VimDeleteCharacterRightAction", "VimDeleteCharacterLeftAction", "VimDeleteVisualAction");

    @Override
    public boolean check(TriggerCheckContext context) {
        String commandName = context.getCommandName();
        Editor editor = context.getEditor();
        if (ALLOW_INLINE_EDIT_FORCE_COMMANDS.contains(commandName)) {
            if (BACKSPACE_COMMANDS.contains(commandName)) {
                return this.isValidBackspaceCommand(editor, context.getNewOffset());
            }
            String changeCode = EditorUtil.getEditTextByOffsetRange(editor.getDocument(), context.getOldOffset(), context.getNewOffset());
            return StringUtils.isNotBlank((CharSequence)changeCode);
        }
        return false;
    }

    private boolean isValidBackspaceCommand(Editor editor, int offset) {
        String lineText = EditorUtil.getLineTextByOffset(editor.getDocument(), offset);
        if (StringUtils.isBlank((CharSequence)lineText)) {
            return false;
        }
        String lineSuffix = DocumentUtils.getLineSuffixByOffset(editor.getDocument(), offset);
        String linePrefix = DocumentUtils.getLinePrefixByOffset(editor.getDocument(), offset);
        return !StringUtils.isBlank((CharSequence)lineSuffix) && !StringUtils.isBlank((CharSequence)linePrefix);
    }

    @Override
    public boolean passAllWhenPassOne() {
        return true;
    }

    @Override
    public boolean ignoreWhenNotPass() {
        return true;
    }
}

