/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.completion.trigger;

import com.alibabacloud.intellij.cosy.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.cosy.completion.trigger.TriggerCheckerAdapter;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;

public class ImportStatementTriggerChecker
extends TriggerCheckerAdapter {
    private static final Logger LOG = Logger.getInstance(ImportStatementTriggerChecker.class);

    @Override
    public boolean check(TriggerCheckContext context) {
        if (context.getEditor() == null || context.getCaretElement() == null) {
            return false;
        }
        Editor editor = context.getEditor();
        PsiElement element = context.getCaretElement();
        if (this.isImportStatement(element, editor)) {
            LOG.debug("Import statement editing detected");
            return true;
        }
        return false;
    }

    private boolean isImportStatement(PsiElement element, Editor editor) {
        return PsiUtils.isImportElement(element, editor);
    }

    @Override
    public boolean passAllWhenPassOne() {
        return true;
    }

    @Override
    public boolean ignoreWhenNotPass() {
        return true;
    }
}

