/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.completion.trigger;

import com.alibabacloud.intellij.cosy.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.cosy.completion.trigger.TriggerCheckerAdapter;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;

public class CommentBelowTriggerChecker
extends TriggerCheckerAdapter {
    private static final Logger LOG = Logger.getInstance(CommentBelowTriggerChecker.class);

    @Override
    public boolean check(TriggerCheckContext context) {
        boolean isPrevLineComment;
        if (context.getEditor() == null || context.getCaretElement() == null) {
            return false;
        }
        Editor editor = context.getEditor();
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(offset);
        if (lineNumber <= 0) {
            return false;
        }
        int prevLineStart = document.getLineStartOffset(lineNumber - 1);
        int prevLineEnd = document.getLineEndOffset(lineNumber - 1);
        String prevLineText = document.getText().substring(prevLineStart, prevLineEnd).trim();
        PsiElement prevElement = context.getCaretElement().getPrevSibling();
        if (prevElement == null) {
            return false;
        }
        boolean bl = isPrevLineComment = prevLineText.startsWith("//") || prevLineText.startsWith("/*") || prevLineText.endsWith("*/") || PsiUtils.isCommentElement(prevElement, editor);
        if (isPrevLineComment) {
            LOG.debug("Editing below comment detected");
            return true;
        }
        return false;
    }

    @Override
    public boolean passAllWhenPassOne() {
        return true;
    }

    @Override
    public boolean ignoreWhenNotPass() {
        return true;
    }
}

