/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.completion;

import com.alibabacloud.intellij.cosy.completion.CosyCompletionService;
import com.alibabacloud.intellij.cosy.completion.model.CompletionRenderType;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.PreCompletionParams;
import com.alibabacloud.intellij.cosy.editor.model.CosyEditorInlayItem;
import com.alibabacloud.intellij.cosy.editor.model.CosyEditorInlayList;
import com.alibabacloud.intellij.cosy.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.cosy.util.CompletionUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CompletionItem;

public class CosyCompletionServiceImpl
implements CosyCompletionService {
    private static final Logger log = Logger.getInstance(CosyCompletionServiceImpl.class);
    private static final long INLAY_COMPLETION_TIMEOUT = 1000L;

    @Override
    public void cancelInlayCompletions(Project project) {
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return;
        }
        Cosy.INSTANCE.getLanguageService(project).cancelInlayCompletion();
    }

    @Override
    public List<CompletionItem> completion(Project project, CompletionParams params, long timeout) {
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).completionWithDebouncer(params, timeout);
    }

    @Override
    public CosyEditorInlayList completionInlay(InlayCompletionRequest request, long timeout) {
        Editor editor = request.getEditor();
        CompletionParams params = request.getParams();
        Project project = editor.getProject();
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return null;
        }
        CosyEditorInlayList result = new CosyEditorInlayList();
        result.setRequest(request);
        List<CompletionItem> items = Cosy.INSTANCE.getLanguageService(project).completionWithDebouncer(params, 1000L, timeout);
        if (items == null || items.isEmpty()) {
            return null;
        }
        for (CompletionItem item : items) {
            CosyEditorInlayItem inlayItem = this.convertInlayItem(request, item, "");
            if (inlayItem == null) {
                log.error("invalid item " + item);
                continue;
            }
            result.add(inlayItem);
        }
        if (result.isEmpty()) {
            return result;
        }
        result.select(0);
        return result;
    }

    @Override
    public void asyncCompletionInlay(InlayCompletionRequest request, long delay, long timeout, Consumer<CompletionParams> consumer) {
        Editor editor = request.getEditor();
        CompletionParams params = request.getParams();
        Project project = editor.getProject();
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return;
        }
        Cosy.INSTANCE.getLanguageService(project).aysncCompletionInlayWithDebouncer(editor, params, delay, timeout, consumer);
    }

    @Override
    public CosyEditorInlayItem convertInlayItem(InlayCompletionRequest request, CompletionItem item, String cursorPrefix) {
        String text = CompletionUtil.getCompletionText(item);
        if (text == null) {
            return null;
        }
        log.debug("inlay completion text:" + text);
        text = StringUtils.stripEnd((String)text, null);
        int index = text.indexOf("<|endoftext|>");
        if (index > 0) {
            text = text.substring(0, index);
        }
        if (text.trim().equals("<|cursor|>")) {
            return null;
        }
        ArrayList<Object> list = null;
        if (!"\n".equals(text)) {
            String[] lines = text.split("\n");
            list = new ArrayList<String>(Arrays.asList(lines));
        } else {
            list = new ArrayList<String>();
            list.add(text);
        }
        if (list.isEmpty()) {
            return null;
        }
        String firstLine = (String)list.remove(0);
        CosyEditorInlayItem data = new CosyEditorInlayItem();
        data.setRequest(request);
        data.setRequestId(request.getParams().getRequestId());
        data.setEditorOffset(request.getCursorOffset());
        data.setContent(text);
        data.addChunk(CompletionRenderType.Inline, Collections.singletonList(firstLine));
        if (!list.isEmpty()) {
            data.addChunk(CompletionRenderType.Block, list);
        }
        if (item.getData() instanceof JsonObject) {
            JsonElement useCacheEl;
            String cacheRequestId;
            JsonObject jsonObject = (JsonObject)item.getData();
            JsonElement cacheIdEl = jsonObject.get("CacheId");
            if (cacheIdEl != null && StringUtils.isNotBlank((CharSequence)(cacheRequestId = cacheIdEl.getAsString()))) {
                data.setCacheId(cacheRequestId);
            }
            if ((useCacheEl = jsonObject.get("useCache")) != null && useCacheEl.getAsBoolean()) {
                data.setUseCache(true);
            }
        }
        return data;
    }

    @Override
    public void preCompletion(Project project, PreCompletionParams preParams, long completionDelay, long timeout) {
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return;
        }
        Cosy.INSTANCE.getLanguageService(project).preCompletionWithDebouncer(preParams, completionDelay, timeout);
    }

    @Override
    public void completionDebounce(InlayCompletionRequest request, long delayTime, Consumer<CompletionParams> consumer) {
        Editor editor = request.getEditor();
        CompletionParams params = request.getParams();
        Project project = editor.getProject();
        LanguageWebSocketService languageService = Cosy.INSTANCE.getLanguageService(project);
        if (languageService == null) {
            return;
        }
        languageService.getInlayCompletionDebouncer().debounce(() -> {
            if (!CompletionUtil.isTriggerWhenLookup(editor)) {
                log.info("cancel completion request by lookup popup, RequestId:" + params.getRequestId());
                return;
            }
            if (consumer != null) {
                consumer.consume((Object)params);
            }
        }, delayTime, TimeUnit.MILLISECONDS);
    }
}

