/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.common;

import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.util.ProcessUtils;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CosyConfig {
    private static final Logger log = Logger.getInstance(CosyConfig.class);
    public static final String SYSTEM_ARCH = CosyConfig.getSystemArch();
    public static final String PLATFORM_NAME = CosyConfig.getPlatformName();
    public static final String COSY_EXECUTABLE_NAME = CosyConfig.getExecutableName();
    public static final String CONFIG_FILE_NAME = "config.json";
    public static final String ENV_FILE_NAME = "env.json";
    public static final String CONFIG_BINARY_VERSION = "cosy.core.version";
    public static final int MAX_COMPLETION_COUNT = 4;
    public static final String COSY_BINARY_RESOURCE = "/binaries/lingma.zip";
    public static final String IDE_VERSION = CosyConfig.getIdeVersion();
    public static final String IDE_NAME = CosyConfig.getIdeName();
    private static final Properties FEATURES_CONFIG = CosyConfig.loadFeatureConfig();

    private static String getSystemArch() {
        String arch;
        String string = arch = SystemInfo.is32Bit ? "i686" : "x86_64";
        if ("aarch64".equals(System.getProperty("os.arch"))) {
            arch = "aarch64";
        }
        log.info(String.format("SYSTEM ARCH: arch=%s, os.arch=%s, is32Bit=%s", arch, System.getProperty("os.arch"), SystemInfo.is32Bit));
        return arch;
    }

    private static String getPlatformName() {
        String platform = null;
        if (SystemInfo.isWindows) {
            platform = "windows";
        } else if (SystemInfo.isMac) {
            platform = "darwin";
        } else if (SystemInfo.isLinux) {
            platform = "linux";
        } else {
            throw new RuntimeException("Cosy only supports platform Windows, macOS, Linux");
        }
        return platform;
    }

    public static Path getHomeDirectory() {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null && StringUtils.isNotBlank((CharSequence)setting.getLocalStoragePath())) {
            File file = new File(setting.getLocalStoragePath());
            boolean validPath = true;
            if (!file.exists()) {
                validPath = file.mkdirs();
            }
            if (validPath) {
                log.debug("use custom local storage path:" + setting.getLocalStoragePath());
                return Paths.get(setting.getLocalStoragePath(), new String[0]);
            }
            log.warn("invalid local storage path:" + setting.getLocalStoragePath());
        }
        return CosyConfig.getDefaultStoragePath();
    }

    public static Path getDefaultStoragePath() {
        return CosyConfig.isQoderEnabled() ? Paths.get(CosyConfig.getUserHome(), ".qoder", "shared_client") : Paths.get(CosyConfig.getUserHome(), ".lingma");
    }

    private static String getUserHome() {
        String userHome = null;
        String osName = System.getProperty("os.name");
        if (StringUtils.isNotBlank((CharSequence)osName)) {
            osName = osName.toLowerCase();
            if (ProcessUtils.isWindowsPlatform()) {
                userHome = System.getenv("USERPROFILE");
            } else if (osName.contains("mac")) {
                userHome = System.getenv("HOME");
            } else if (osName.contains("nix") || osName.contains("nux")) {
                userHome = System.getenv("HOME");
            }
        }
        if (StringUtils.isBlank(userHome)) {
            return System.getProperty("user.home");
        }
        return userHome;
    }

    private static String getExecutableName() {
        return SystemInfo.isWindows ? "Lingma.exe" : "Lingma";
    }

    private static String getIdeVersion() {
        return ApplicationInfo.getInstance().getFullVersion();
    }

    private static String getIdeName() {
        return ApplicationInfo.getInstance().getVersionName();
    }

    private static Properties loadFeatureConfig() {
        Properties properties = new Properties();
        try (InputStream stream = CosyConfig.class.getResourceAsStream("/features.properties");){
            if (stream != null) {
                properties.load(stream);
            }
        }
        catch (Exception e) {
            log.warn("load feature config failed", (Throwable)e);
        }
        return properties;
    }

    public static String getFeature(String key, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return defaultValue;
        }
        return FEATURES_CONFIG.getProperty(key, defaultValue);
    }

    public static boolean getFeature(String key, boolean defaultValue) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return defaultValue;
        }
        String feature = FEATURES_CONFIG.getProperty(key, String.valueOf(defaultValue));
        if (StringUtils.isBlank((CharSequence)feature)) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(feature);
        }
        catch (Exception e) {
            log.warn("parse feature config failed", (Throwable)e);
            return defaultValue;
        }
    }

    public static List<String> getFeature(String key, List<String> defaultValue) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return defaultValue;
        }
        String feature = FEATURES_CONFIG.getProperty(key, String.valueOf(defaultValue));
        if (StringUtils.isBlank((CharSequence)feature)) {
            return defaultValue;
        }
        try {
            return Arrays.asList(feature.split(","));
        }
        catch (Exception e) {
            log.warn("parse feature config failed", (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean containsFeature(String featuresKey, String key) {
        List<String> features = CosyConfig.getFeature(featuresKey, Collections.emptyList());
        return CollectionUtils.isNotEmpty(features) && features.contains(key);
    }

    public static boolean isQoderEnabled() {
        return "qoder".equals(CosyConfig.getFeature(BuildFeature.PRODUCT.getKey(), "lingma"));
    }
}

