/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.processor;

import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.cosy.tool.handler.CreateNewFileWithTextToolHandler;
import com.alibabacloud.intellij.cosy.tool.handler.DeleteFileByPathToolHandler;
import com.alibabacloud.intellij.cosy.tool.handler.GetProblemsToolHandler;
import com.alibabacloud.intellij.cosy.tool.handler.GetTerminalOutputToolHandler;
import com.alibabacloud.intellij.cosy.tool.handler.ReadFileToolHandler;
import com.alibabacloud.intellij.cosy.tool.handler.ReplaceTextByPathToolHandler;
import com.alibabacloud.intellij.cosy.tool.handler.RunTerminalToolHandlerV2;
import com.alibabacloud.intellij.cosy.tool.handler.SaveFileToolHandler;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;

public class ToolInvokeProcessor {
    private static final Logger log = Logger.getInstance(ToolInvokeProcessor.class);
    private static final String TOOL_GET_TERMINAL_OUTPUT = "get_terminal_output";
    private static final String TOOL_RUN_TERMINAL = "run_in_terminal";
    private static final String TOOL_GET_PROBLEMS = "get_problems";
    private static final String TOOL_REPLACE_TEXT_BY_PATH = "replace_text_by_path";
    private static final String TOOL_CREATE_FILE_WITH_TEXT_BY_PATH = "create_file_with_text";
    private static final String TOOL_DELETE_FILE_BY_PATH = "delete_file_by_path";
    private static final String TOOL_READ_FILE = "read_file";
    private static final String TOOL_SAVE_FILE = "save_file";
    private ToolInvokeRequest request;
    private Project project;

    public ToolInvokeProcessor(Project project, ToolInvokeRequest request) {
        this.project = project;
        this.request = request;
    }

    public ToolInvokeResponse invokeTool() {
        if (BooleanUtils.isTrue((Boolean)this.request.getAsync())) {
            ThreadUtil.execute(() -> {
                ToolInvokeResponse toolInvokeResponse = this.invokeTool(this.project);
                if (!Cosy.INSTANCE.checkCosy(this.project)) {
                    log.warn("ToolInvokeProcessor toolInvokeResult checkCosy failed");
                    return;
                }
                try {
                    Cosy.INSTANCE.getLanguageService(this.project).reportToolInvokeResult(toolInvokeResponse, 360000L);
                }
                catch (Exception e) {
                    log.warn("ToolInvokeProcessor toolInvokeResult errorMessage=" + e.getMessage());
                }
            });
            return ToolInvokeResponse.success(this.request.getToolCallId(), this.request.getName(), new HashMap<String, Object>());
        }
        return this.invokeTool(this.project);
    }

    private ToolInvokeResponse invokeTool(Project project) {
        switch (this.request.getName()) {
            case "get_terminal_output": {
                GetTerminalOutputToolHandler getTerminalOutputToolHandler = new GetTerminalOutputToolHandler();
                return getTerminalOutputToolHandler.handle(project, this.request);
            }
            case "run_in_terminal": {
                RunTerminalToolHandlerV2 runTerminalToolHandler = new RunTerminalToolHandlerV2();
                return runTerminalToolHandler.handle(project, this.request);
            }
            case "get_problems": {
                GetProblemsToolHandler getProblemsToolHandler = new GetProblemsToolHandler();
                return getProblemsToolHandler.handle(project, this.request);
            }
            case "replace_text_by_path": {
                return new ReplaceTextByPathToolHandler().handle(project, this.request);
            }
            case "create_file_with_text": {
                return new CreateNewFileWithTextToolHandler().handle(project, this.request);
            }
            case "delete_file_by_path": {
                return new DeleteFileByPathToolHandler().handle(project, this.request);
            }
            case "read_file": {
                return new ReadFileToolHandler().handle(project, this.request);
            }
            case "save_file": {
                return new SaveFileToolHandler().handle(project, this.request);
            }
        }
        log.warn("ToolInvokeProcessor tool not support yet, toolName=" + this.request.getName());
        return ToolInvokeResponse.failed(this.request.getToolCallId(), this.request.getName(), "tool not support yet");
    }
}

