/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.processor;

import com.alibabacloud.intellij.cosy.chat.model.ChatQuotaRemindRequest;
import com.alibabacloud.intellij.cosy.chat.processor.ChatFinishProcessor;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatNotification;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatNotificationRequest;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ChatNotificationProcessor {
    private static final Logger log = Logger.getInstance(ChatFinishProcessor.class);
    public static final ChatNotificationProcessor INSTANCE = new ChatNotificationProcessor();

    private ChatNotificationProcessor() {
    }

    public Void processNotification(ChatNotificationRequest request) {
        Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(request.getRequestId());
        if (project == null) {
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(request.getRequestId());
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(request.getRequestId());
            log.warn("Cannot find project in chat notification processor by requestId " + request.getRequestId());
            return null;
        }
        if (CollectionUtils.isNotEmpty(request.getNotifications())) {
            for (ChatNotification notification : request.getNotifications()) {
                switch (notification.getNotificationType()) {
                    case "quota_low": {
                        String message;
                        if (Boolean.TRUE.equals(notification.getIsHighestTier())) {
                            message = CosyBundle.message("quota.low.text.highest", notification.getExtras().getPricingUrl());
                            NotificationFactory.showNotification(project, NotificationType.WARNING, message, new AnAction[]{new ChatNotificationAction(CosyBundle.message("quota.do.not.remind.me.again", new Object[0]), Void2 -> Cosy.INSTANCE.getLanguageService(project).dontRemindMeQuota(new ChatQuotaRemindRequest(true, notification.getNotificationType())))});
                            break;
                        }
                        message = CosyBundle.message("quota.low.text", new Object[0]);
                        NotificationFactory.showNotification(project, NotificationType.WARNING, message, new AnAction[]{new ChatNotificationAction(CosyBundle.message("quota.get.more.credits.text", new Object[0]), Void2 -> BrowserUtil.browse((String)notification.getExtras().getPricingUrl())), new ChatNotificationAction(CosyBundle.message("quota.do.not.remind.me.again", new Object[0]), Void2 -> Cosy.INSTANCE.getLanguageService(project).dontRemindMeQuota(new ChatQuotaRemindRequest(true, notification.getNotificationType())))});
                        break;
                    }
                    case "quota_exceeded": {
                        String message;
                        if (Boolean.TRUE.equals(notification.getIsHighestTier())) {
                            message = CosyBundle.message("quota.exceed.text.highest", notification.getExtras().getPricingUrl());
                            NotificationFactory.showNotification(project, NotificationType.WARNING, message, new AnAction[]{new ChatNotificationAction(CosyBundle.message("quota.do.not.remind.me.again", new Object[0]), Void2 -> Cosy.INSTANCE.getLanguageService(project).dontRemindMeQuota(new ChatQuotaRemindRequest(true, notification.getNotificationType())))});
                            break;
                        }
                        message = CosyBundle.message("quota.exceed.text", new Object[0]);
                        NotificationFactory.showNotification(project, NotificationType.WARNING, message, new AnAction[]{new ChatNotificationAction(CosyBundle.message("quota.get.more.credits.text", new Object[0]), Void2 -> BrowserUtil.browse((String)notification.getExtras().getPricingUrl())), new ChatNotificationAction(CosyBundle.message("quota.do.not.remind.me.again", new Object[0]), Void2 -> Cosy.INSTANCE.getLanguageService(project).dontRemindMeQuota(new ChatQuotaRemindRequest(true, notification.getNotificationType())))});
                        break;
                    }
                    case "quota_expire_soon": {
                        String message = CosyBundle.message("plan.expire.soon.text", new Object[0]);
                        NotificationFactory.showNotification(project, NotificationType.WARNING, message, new AnAction[]{new ChatNotificationAction(CosyBundle.message("plan.expire.soon.renew.text", new Object[0]), Void2 -> BrowserUtil.browse((String)notification.getExtras().getRenewUrl()))});
                        break;
                    }
                    case "trial_expire_soon": {
                        String message = CosyBundle.message("pro.trial.expire.soon.text", new Object[0]);
                        NotificationFactory.showNotification(project, NotificationType.WARNING, message, new AnAction[]{new ChatNotificationAction(CosyBundle.message("pro.trial.expire.soon.upgrade.text", new Object[0]), Void2 -> BrowserUtil.browse((String)notification.getExtras().getUpgradeUrl()))});
                    }
                }
            }
        }
        return null;
    }

    public static class ChatNotificationAction
    extends NotificationAction {
        private final Consumer<Void> callback;

        public ChatNotificationAction(String text, Consumer<Void> callback) {
            super(text);
            this.callback = callback;
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                ChatNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                ChatNotificationAction.$$$reportNull$$$0(1);
            }
            if (null != this.callback) {
                this.callback.accept(null);
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/chat/processor/ChatNotificationProcessor$ChatNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

