/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.model;

import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.ScopeChatAskTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ChatAskInput {
    @Deprecated
    private String text;
    @Deprecated
    private List<ChatAskTag> tags;
    private List<ChatInputElement> chatInputElements;
    private List<ChatContextTag> contextTags;
    public static final String ASK_TAG_LABEL = "LINGMA_ASK_TAG";
    private static final String KEY_USE_ELEMENT = "{{useContext";
    private static final Pattern CONTEXT_PATTERN = Pattern.compile("\\{\\{useContext:(.*?)\\}\\}");

    public ChatAskInput() {
        this.contextTags = new ArrayList<ChatContextTag>();
        this.chatInputElements = new ArrayList<ChatInputElement>();
    }

    public ChatAskInput(String text, List<ChatAskTag> tags, List<ChatContextTag> contextTags) {
        if (CollectionUtils.isEmpty(contextTags) && (text == null || !text.contains(KEY_USE_ELEMENT))) {
            this.text = text;
            this.tags = tags;
            this.chatInputElements = new ArrayList<ChatInputElement>();
            this.contextTags = new ArrayList<ChatContextTag>();
            if (tags != null) {
                tags.forEach(chatAskTag -> this.chatInputElements.add(ChatInputElement.builder().type("tag").tag((ChatAskTag)chatAskTag).build()));
            }
            if (StringUtils.isNotBlank((CharSequence)text)) {
                this.chatInputElements.add(ChatInputElement.builder().type("text").text(text).build());
            }
        } else {
            this.parseContextText(text, tags, contextTags);
        }
    }

    private void parseContextText(String text, List<ChatAskTag> tags, List<ChatContextTag> contextTags) {
        if (tags == null) {
            tags = new ArrayList<ChatAskTag>();
        }
        if (contextTags == null) {
            contextTags = new ArrayList<ChatContextTag>();
        }
        this.chatInputElements = new ArrayList<ChatInputElement>();
        this.contextTags = contextTags;
        tags.forEach(tag -> this.chatInputElements.add(ChatInputElement.builder().type("tag").tag((ChatAskTag)tag).build()));
        Matcher m = CONTEXT_PATTERN.matcher(text);
        Integer idx = 0;
        while (m.find()) {
            Integer contextIdx = text.indexOf(m.group());
            if (contextIdx > idx) {
                this.chatInputElements.add(ChatInputElement.builder().type("text").text(text.substring(idx, contextIdx)).build());
            }
            idx = contextIdx + m.group().length();
            String context = m.group(1);
            String[] ids = context.split(":");
            String id = ids.length > 1 ? String.join((CharSequence)":", Arrays.asList(ids).subList(1, ids.length)) : ids[ids.length - 1];
            Optional<ChatContextTag> tag2 = contextTags.stream().filter(t -> id.equals(t.getId())).findAny();
            if (!tag2.isPresent()) continue;
            this.chatInputElements.add(ChatInputElement.builder().type("tag").tag(ChatAskTag.buildTagFromContext(tag2.get())).build());
        }
        if (idx < text.length()) {
            this.chatInputElements.add(ChatInputElement.builder().type("text").text(text.substring(idx)).build());
        }
    }

    public String getText() {
        if (CollectionUtils.isNotEmpty(this.chatInputElements)) {
            StringBuilder ret = new StringBuilder();
            this.chatInputElements.forEach(element -> {
                switch (element.getType()) {
                    case "tag": {
                        ChatContextTag contextTag;
                        String tagId;
                        String type;
                        ChatAskTag askTag = element.getTag();
                        if (askTag == null || "task".equals(type = askTag.getType()) || "agent".equals(type)) break;
                        if (askTag instanceof ScopeChatAskTag && (tagId = askTag.getId()) != null && (contextTag = (ChatContextTag)this.contextTags.stream().filter(t -> t.equalsToAskTag(askTag)).findAny().orElse(null)) != null && !contextTag.getActualValid().booleanValue()) {
                            ret.append(askTag.getDisplayText());
                            element.setText(askTag.getDisplayText());
                            element.setTag(null);
                            element.setType("text");
                            this.contextTags.remove(contextTag);
                            break;
                        }
                        Object text = KEY_USE_ELEMENT;
                        if (askTag instanceof ScopeChatAskTag && null != ((ScopeChatAskTag)askTag).getContextProvider()) {
                            text = (String)text + ":" + ((ScopeChatAskTag)askTag).getContextProvider().getId();
                        }
                        text = (String)text + ":" + askTag.getId() + "}}";
                        ret.append((String)text);
                        break;
                    }
                    case "text": {
                        if (StringUtils.isBlank((CharSequence)element.getText()) || element.getText().equals("\n")) break;
                        ret.append(element.getText());
                        break;
                    }
                }
            });
            return ret.toString();
        }
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<ChatAskTag> getTags() {
        if (CollectionUtils.isEmpty(this.chatInputElements)) {
            return new ArrayList<ChatAskTag>();
        }
        ArrayList<ChatAskTag> tags = new ArrayList<ChatAskTag>();
        for (ChatInputElement chatInputElement : this.chatInputElements) {
            ChatAskTag chatAskTag;
            if ("text".equals(chatInputElement.getType()) || (chatAskTag = chatInputElement.getTag()) == null || !"task".equals(chatAskTag.getType()) && !"agent".equals(chatAskTag.getType())) continue;
            tags.add(chatAskTag);
        }
        return tags;
    }

    public void setTags(List<ChatAskTag> tags) {
        this.tags = tags;
    }

    public List<ChatInputElement> getChatInputElements() {
        return this.chatInputElements;
    }

    public void setChatInputElements(List<ChatInputElement> chatInputElements) {
        this.chatInputElements = chatInputElements;
    }

    public List<ChatContextTag> getContextTags() {
        return this.contextTags;
    }

    public void setContextTags(List<ChatContextTag> contextTags) {
        this.contextTags = contextTags;
    }

    public String toMarkdownLabelString(boolean needConvertUrlsToMarkdown) {
        StringBuilder result = new StringBuilder();
        for (ChatInputElement element : this.chatInputElements) {
            if (element.getType().equals("text")) {
                if (needConvertUrlsToMarkdown) {
                    result.append(this.convertUrlsToMarkdown(element.getText()));
                    continue;
                }
                result.append(element.getText());
                continue;
            }
            if (!element.getType().equals("tag") || element.getTag() == null) continue;
            ChatAskTag askTag = element.getTag();
            String content = element.getTag().getDisplayText();
            ChatContextTag tag = null;
            if (StringUtils.isNotBlank((CharSequence)askTag.getId())) {
                tag = this.contextTags.stream().filter(t -> t.equalsToAskTag(askTag)).findAny().orElse(null);
            }
            content = tag != null ? tag.toMarkdownLabelString(content) : String.format("`%s`", content);
            result.append(" " + content + " ");
        }
        return result.toString();
    }

    private String convertUrlsToMarkdown(String text) {
        if (StringUtils.isBlank((CharSequence)text) || !text.contains("http")) {
            return text;
        }
        if (text.contains("$") || text.contains("\\")) {
            return text;
        }
        String urlPattern = "https?://[\\w\\d\\-._~:/?#\\[\\]@!$&'()*+,;=]+";
        Pattern pattern = Pattern.compile(urlPattern);
        Matcher matcher = pattern.matcher(text);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String url = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            boolean isMarkdown = false;
            if (start >= 1 && end >= 1 && text.charAt(start - 1) == '[' && text.charAt(end - 1) == ')') {
                isMarkdown = text.substring(start - 1, end).contains("](");
            }
            if (isMarkdown) {
                matcher.appendReplacement(result, url);
                continue;
            }
            String markdownUrl = String.format("[%s](%s)", url, url);
            matcher.appendReplacement(result, markdownUrl);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

