/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.factory;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.factory.BaseChatContextDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.CodeProblemSolveDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.CodeRelatedDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.ContinueTaskDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.CustomCommandDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.DescriptionCodeDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.ExplainCodeDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.QuestionDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.QuestionObjectDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.ReplyTaskDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.RetryTaskDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.TerminalRelatedDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.TestcaseGenerationDtoBuilder;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ChatContextDtoBuilderFactory {
    public static BaseChatContextDtoBuilder getChatContextDtoBuilder(String chatTask) {
        if (chatTask == null) {
            return null;
        }
        boolean isSystemTask = Arrays.stream(ChatTaskEnum.values()).map(ChatTaskEnum::getName).collect(Collectors.toList()).contains(chatTask);
        if (ChatTaskEnum.DESCRIPTION_GENERATE_CODE.getName().equals(chatTask)) {
            return new DescriptionCodeDtoBuilder();
        }
        if (ChatTaskEnum.EXPLAIN_CODE.getName().equals(chatTask)) {
            return new ExplainCodeDtoBuilder();
        }
        if (ChatTaskEnum.GENERATE_TESTCASE.getName().equals(chatTask)) {
            return new TestcaseGenerationDtoBuilder();
        }
        if (InputConstants.SIMPLE_CODE_RELATED_TASKS.contains(chatTask)) {
            return new CodeRelatedDtoBuilder();
        }
        if (InputConstants.QUESTION_OBJECT_TASKS.contains(chatTask)) {
            return new QuestionObjectDtoBuilder();
        }
        if (ChatTaskEnum.REPLY_TASK.getName().equals(chatTask)) {
            return new ReplyTaskDtoBuilder();
        }
        if (ChatTaskEnum.CONTINUE_TASK.getName().equals(chatTask)) {
            return new ContinueTaskDtoBuilder();
        }
        if (ChatTaskEnum.RETRY_TASK.getName().equals(chatTask)) {
            return new RetryTaskDtoBuilder();
        }
        if (ChatTaskEnum.CODE_PROBLEM_SOLVE.getName().equals(chatTask)) {
            return new CodeProblemSolveDtoBuilder();
        }
        if (ChatTaskEnum.TERMINAL_EXPLAIN_FIX.getName().equals(chatTask)) {
            return new TerminalRelatedDtoBuilder();
        }
        if (!isSystemTask) {
            return new CustomCommandDtoBuilder();
        }
        return new QuestionDtoBuilder();
    }
}

