/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.enums;

import com.intellij.openapi.diagnostic.Logger;
import lombok.Generated;

public enum ResponseLanguageEnum {
    ZH("zh-cn", "\u7b80\u4f53\u4e2d\u6587"),
    EN("en", "English"),
    JA("ja", "\u65e5\u672c\u8a9e"),
    KO("ko", "\ud55c\uad6d\uc5b4"),
    FR("fr", "Fran\u00e7ais"),
    DE("de", "Deutsch"),
    ES("es", "Espa\u00f1ol"),
    PT("pt", "Portugu\u00eas");

    private static final Logger log;
    private final String id;
    private final String name;

    private ResponseLanguageEnum(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static String getName(String id) {
        for (ResponseLanguageEnum value : ResponseLanguageEnum.values()) {
            if (!value.id.equals(id)) continue;
            return value.name;
        }
        log.warn("getName by id failed, id: " + id + ", use default language");
        return ResponseLanguageEnum.ZH.name;
    }

    public static String getId(String name) {
        for (ResponseLanguageEnum value : ResponseLanguageEnum.values()) {
            if (!value.name.equals(name)) continue;
            return value.id;
        }
        return null;
    }

    public static String[] getNames() {
        ResponseLanguageEnum[] values = ResponseLanguageEnum.values();
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].name;
        }
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        log = Logger.getInstance(ResponseLanguageEnum.class);
    }
}

