/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context.tool;

import com.alibabacloud.intellij.cosy.chat.context.tool.BaseToolContextProvider;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ToolAutoRunModeItem;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.approval.ToolApprovalPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.approval.WebToolApprovalPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.SearchWebToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang.StringUtils;

public class SearchWebToolContextProvider
extends BaseToolContextProvider {
    @Override
    public String getToolNameAndStatus(ToolCallStatusEnum status, String toolName) {
        switch (status) {
            case INIT: 
            case PENDING: {
                return CosyBundle.message("tool.search.web", new Object[0]);
            }
            case RUNNING: {
                return CosyBundle.message("tool.searching.web", new Object[0]);
            }
            case FINISHED: {
                return CosyBundle.message("tool.searched.web", new Object[0]);
            }
            case CANCELLED: {
                return CosyBundle.message("tool.search.web.canceled", new Object[0]);
            }
            case ERROR: {
                return CosyBundle.message("tool.search.web.failed", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public JComponent getScopeLabel(Project project, ToolCallInfo toolCallInfo, int maxWidth) {
        if (toolCallInfo.getParameters() == null || !toolCallInfo.getParameters().containsKey("query")) {
            return null;
        }
        String query = (String)toolCallInfo.getParameters().get("query");
        if (StringUtils.isNotBlank((String)query)) {
            JLabel queryLabel = new JLabel();
            queryLabel.setText(FontUtil.getStringAdaptiveWidth(queryLabel, query, maxWidth, false));
            queryLabel.setFont(queryLabel.getFont().deriveFont(JBUIScale.scale((float)12.0f)));
            queryLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            return queryLabel;
        }
        return null;
    }

    @Override
    public String getScopeContent(Project project, ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getParameters() == null || !toolCallInfo.getParameters().containsKey("query")) {
            return null;
        }
        return (String)toolCallInfo.getParameters().get("query");
    }

    @Override
    public ToolApprovalPanel initToolApprovalPanel(Project project, ToolPanel toolPanel) {
        this.addToolAutoRunChooser(project, toolPanel, item -> this.updateWebToolsAutoRun(project, (ToolAutoRunModeItem)item));
        return new WebToolApprovalPanel(project, toolPanel);
    }

    @Override
    public ToolDetailPanel initToolDetailPanel(Project project, ToolPanel toolPanel) {
        return new SearchWebToolDetailPanel(project, toolPanel);
    }
}

