/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context.tool;

import com.alibabacloud.intellij.cosy.chat.context.tool.BaseToolContextProvider;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.ToolCountStyleEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Cursor;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class ReadFileToolContextProvider
extends BaseToolContextProvider {
    private static final Logger log = Logger.getInstance(ReadFileToolContextProvider.class);

    @Override
    public Icon getIcon(ToolCallStatusEnum status) {
        return null;
    }

    @Override
    public String getToolNameAndStatus(ToolCallStatusEnum status, String toolName) {
        switch (status) {
            case INIT: {
                return CosyBundle.message("tool.read.file", new Object[0]);
            }
            case RUNNING: {
                return CosyBundle.message("tool.reading.file", new Object[0]);
            }
            case FINISHED: {
                return CosyBundle.message("tool.finish.read.file", new Object[0]);
            }
            case ERROR: 
            case CANCELLED: {
                return CosyBundle.message("tool.read.file.failed", new Object[0]);
            }
        }
        return null;
    }

    private String getStringValue(Map<String, Object> params, String paramName) {
        if (params == null) {
            return null;
        }
        Object value = params.get(paramName);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    private Boolean getBooleanValue(Map<String, Object> params, String paramName) {
        if (params == null) {
            return null;
        }
        Object value = params.get(paramName);
        if (value == null) {
            return null;
        }
        return value instanceof Boolean ? Boolean.valueOf((Boolean)value) : null;
    }

    private Double getDoubleValue(Map<String, Object> params, String paramName) {
        if (params == null) {
            return null;
        }
        Object value = params.get(paramName);
        if (value == null) {
            return null;
        }
        return value instanceof Double ? (Double)value : null;
    }

    @Override
    public String getParamValue(ToolCallInfo toolCallInfo, String paramName) {
        if (toolCallInfo == null || StringUtils.isBlank((String)paramName)) {
            return null;
        }
        return this.getStringValue(toolCallInfo.getParameters(), paramName);
    }

    @Override
    public JComponent getScopeLabel(Project project, ToolCallInfo toolCallInfo, int maxWidth) {
        Map<String, Object> result;
        if (toolCallInfo.getParameters() == null) {
            return null;
        }
        String path = null;
        Double startLine = null;
        Double endLine = null;
        if (CollectionUtils.isNotEmpty(toolCallInfo.getResults()) && (result = toolCallInfo.getResults().get(0)).containsKey("path") && StringUtils.isNotBlank((String)(path = (String)result.get("path"))) && result.containsKey("startLine") && result.containsKey("endLine")) {
            startLine = (Double)result.get("startLine");
            endLine = (Double)result.get("endLine");
        }
        if (null == path || null == startLine && null != endLine || null != startLine && null == endLine) {
            log.warn("getScopeLabel params failed in results, path: " + path + " startLine: " + startLine + " endLine: " + endLine);
            Map<String, Object> params = toolCallInfo.getParameters();
            path = this.getStringValue(params, "file_path");
            if (StringUtils.isBlank((String)path)) {
                return null;
            }
            Boolean readEntireFile = this.getBooleanValue(params, "read_entire_file");
            if (BooleanUtils.isTrue((Boolean)readEntireFile)) {
                return this.getFileLabel(project, path, maxWidth);
            }
            startLine = this.getDoubleValue(params, "start_line");
            endLine = this.getDoubleValue(params, "end_line");
        }
        if (startLine == null || endLine == null) {
            return this.getFileLabel(project, path, maxWidth);
        }
        JLabel fileLabel = this.getFileLabel(project, path, maxWidth);
        if (fileLabel.getText().contains("...")) {
            return fileLabel;
        }
        String readLine = startLine.intValue() + "-" + endLine.intValue();
        Box box = Box.createHorizontalBox();
        box.add(fileLabel);
        box.add(Box.createHorizontalStrut(JBUIScale.scale((int)4)));
        JLabel readLineLabel = this.getReadLineLabel(readLine);
        box.add(readLineLabel);
        return box;
    }

    @Override
    public String getScopeContent(Project project, ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getParameters() == null) {
            return null;
        }
        Map<String, Object> params = toolCallInfo.getParameters();
        String path = this.getStringValue(params, "file_path");
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        Boolean readEntireFile = this.getBooleanValue(params, "read_entire_file");
        if (BooleanUtils.isTrue((Boolean)readEntireFile)) {
            return FileUtil.getFileName(path);
        }
        Double startLine = this.getDoubleValue(params, "start_line");
        Double endLine = this.getDoubleValue(params, "end_line");
        if (startLine == null || endLine == null) {
            return FileUtil.getFileName(path);
        }
        String readLine = startLine.intValue() + "-" + endLine.intValue();
        return FileUtil.getFileName(path) + " " + readLine;
    }

    private JLabel getFileLabel(Project project, String path, int maxWidth) {
        JLabel fileLabel = new JLabel();
        fileLabel.setFont(fileLabel.getFont().deriveFont(JBUIScale.scale((float)12.0f)));
        fileLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        fileLabel.setText(FontUtil.clipStringMiddle(FontUtil.fontMetrics(fileLabel, fileLabel.getFont()), FileUtil.getFileName(path), maxWidth));
        fileLabel.setCursor(Cursor.getPredefinedCursor(12));
        return fileLabel;
    }

    private JLabel getReadLineLabel(String lineRange) {
        JLabel readLineLabel = new JLabel();
        readLineLabel.setText(lineRange);
        readLineLabel.setFont(readLineLabel.getFont().deriveFont(JBUIScale.scale((float)12.0f)));
        readLineLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        readLineLabel.setCursor(Cursor.getPredefinedCursor(12));
        return readLineLabel;
    }

    @Override
    public ToolCountStyleEnum needRenderResultCount() {
        return ToolCountStyleEnum.NONE;
    }

    @Override
    public ToolDetailPanel initToolDetailPanel(Project project, ToolPanel toolPanel) {
        return null;
    }
}

