/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context.tool;

import com.alibabacloud.intellij.cosy.chat.context.tool.BaseToolContextProvider;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.ListDirToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang.StringUtils;

public class ListDirToolContextProvider
extends BaseToolContextProvider {
    @Override
    public Icon getIcon(ToolCallStatusEnum status) {
        return null;
    }

    @Override
    public String getToolNameAndStatus(ToolCallStatusEnum status, String toolName) {
        switch (status) {
            case INIT: {
                return CosyBundle.message("tool.list.dir", new Object[0]);
            }
            case RUNNING: {
                return CosyBundle.message("tool.listing.dir", new Object[0]);
            }
            case FINISHED: {
                return CosyBundle.message("tool.listed.dir", new Object[0]);
            }
            case ERROR: 
            case CANCELLED: {
                return CosyBundle.message("tool.list.dir.failed", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public JComponent getScopeLabel(Project project, ToolCallInfo toolCallInfo, int maxWidth) {
        if (toolCallInfo.getParameters() == null || !toolCallInfo.getParameters().containsKey("relative_workspace_path")) {
            return null;
        }
        String relativeWorkspacePath = (String)toolCallInfo.getParameters().get("relative_workspace_path");
        if (StringUtils.isNotBlank((String)relativeWorkspacePath)) {
            if (".".equals(relativeWorkspacePath)) {
                JLabel workspaceLabel = new JLabel();
                workspaceLabel.setText(FontUtil.getStringAdaptiveWidth(workspaceLabel, CosyBundle.message("tool.text.current.project", new Object[0]), maxWidth, false));
                workspaceLabel.setFont(workspaceLabel.getFont().deriveFont(JBUIScale.scale((float)12.0f)));
                workspaceLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                return workspaceLabel;
            }
            JLabel workspaceLabel = new JLabel();
            workspaceLabel.setText(FontUtil.getStringAdaptiveWidth(workspaceLabel, relativeWorkspacePath, maxWidth, true));
            workspaceLabel.setFont(workspaceLabel.getFont().deriveFont(JBUIScale.scale((float)12.0f)));
            workspaceLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            return workspaceLabel;
        }
        return null;
    }

    @Override
    public String getScopeContent(Project project, ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getParameters() == null || !toolCallInfo.getParameters().containsKey("relative_workspace_path")) {
            return null;
        }
        String relativeWorkspacePath = (String)toolCallInfo.getParameters().get("relative_workspace_path");
        if (StringUtils.isNotBlank((String)relativeWorkspacePath)) {
            if (".".equals(relativeWorkspacePath)) {
                return CosyBundle.message("tool.text.current.project", new Object[0]);
            }
            return relativeWorkspacePath;
        }
        return null;
    }

    @Override
    public ToolDetailPanel initToolDetailPanel(Project project, ToolPanel toolPanel) {
        return new ListDirToolDetailPanel(project, toolPanel);
    }
}

