/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context.tool;

import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalWebToolsAutoExecuteConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ToolAutoRunModeItem;
import com.alibabacloud.intellij.cosy.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.cosy.search.enums.WebToolsExecutionModeEnum;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.chooser.ToolAutoRunChooser;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.approval.ToolApprovalPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.ToolCountStyleEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.project.Project;
import icons.LingmaIcons;
import java.awt.Color;
import java.util.function.Function;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang.StringUtils;

public abstract class BaseToolContextProvider {
    public Icon getIcon(ToolCallStatusEnum status) {
        switch (status) {
            case INIT: 
            case PENDING: {
                return LingmaIcons.PendingGreyIcon;
            }
            case RUNNING: {
                return LingmaIcons.DoingBlue16Icon;
            }
            case CANCELLED: {
                return LingmaIcons.ErrorRed16Icon;
            }
            case FINISHED: {
                return LingmaIcons.AcceptGreen16Icon;
            }
            case ERROR: {
                return LingmaIcons.Warning16YellowIcon;
            }
        }
        return null;
    }

    public String getParamValue(ToolCallInfo toolCallInfo, String paramName) {
        return null;
    }

    public static String getErrorMsg(String errorCode, String errorMsg) {
        if (StringUtils.isEmpty((String)errorCode)) {
            return "";
        }
        switch (errorCode) {
            case "30404": {
                return CosyBundle.message("message.error.tool.call.file.not.exist", new Object[0]);
            }
            case "40400": {
                return CosyBundle.message("message.error.tool.call.unexpected", new Object[0]);
            }
            case "40403": {
                return CosyBundle.message("message.error.tool.call.disabled", new Object[0]);
            }
            case "40404": {
                return CosyBundle.message("message.error.tool.call.not.found", new Object[0]);
            }
            case "40500": {
                return CosyBundle.message("message.error.tool.call.exception", new Object[0]);
            }
            case "40441": {
                return CosyBundle.message("message.error.tool.call.interrupted", new Object[0]);
            }
            case "40504": {
                return CosyBundle.message("message.error.tool.call.timeout", new Object[0]);
            }
            case "31404": {
                return CosyBundle.message("message.error.tool.call.directory.not.existed", new Object[0]);
            }
            case "50001": {
                return CosyBundle.message("message.error.tool.call.mcp.server.not.connected", new Object[0]);
            }
            case "51404": {
                return CosyBundle.message("message.error.tool.call.mcp.tool.not.found", new Object[0]);
            }
            case "51500": {
                return String.format(CosyBundle.message("message.error.tool.call.mcp.tool.execution.error", new Object[0]), errorMsg);
            }
            case "60001": {
                return String.format(CosyBundle.message("message.error.tool.call.web.tool.status.error", new Object[0]), errorMsg);
            }
        }
        return CosyBundle.message("message.error.tool.call.exception", new Object[0]);
    }

    public JComponent getScopeLabel(Project project, ToolCallInfo toolCallInfo, int maxWidth) {
        return null;
    }

    public String getScopeContent(Project project, ToolCallInfo toolCallInfo) {
        return "";
    }

    public ToolCountStyleEnum needRenderResultCount() {
        return ToolCountStyleEnum.COUNT_AND_DOWN_ARROW;
    }

    public ToolApprovalPanel initToolApprovalPanel(Project project, ToolPanel toolPanel) {
        return null;
    }

    public abstract String getToolNameAndStatus(ToolCallStatusEnum var1, String var2);

    public abstract ToolDetailPanel initToolDetailPanel(Project var1, ToolPanel var2);

    public Color getTitleLabelForegroundColor() {
        return ColorUtil.getLabelForegroundColor();
    }

    public boolean showDetailPanelDefault() {
        return false;
    }

    protected void addToolAutoRunChooser(Project project, ToolPanel toolPanel, Function<ToolAutoRunModeItem, Boolean> selectChecker) {
        this.addToolRunComponent(toolPanel, new ToolAutoRunChooser(project, selectChecker).getBaseComponent());
    }

    protected void addToolRunTips(ToolPanel toolPanel, String text) {
        JLabel tipsLabel = new JLabel(text);
        tipsLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        tipsLabel.setFont(tipsLabel.getFont().deriveFont(0, 12.0f));
        this.addToolRunComponent(toolPanel, tipsLabel);
    }

    protected void addToolRunComponent(ToolPanel toolPanel, JComponent component) {
        Box operateBox = toolPanel.getResultAndOperateBox();
        if (null != operateBox) {
            Box panel = Box.createHorizontalBox();
            panel.setBackground(ColorUtil.getEditorBackgroundColor());
            if (operateBox.getComponentCount() > 0) {
                panel.add(Box.createHorizontalStrut(8));
            }
            panel.add(component);
            toolPanel.setToolAutoRunChooser(panel);
            operateBox.add(toolPanel.getToolAutoRunChooser());
        }
    }

    protected boolean updateWebToolsAutoRun(Project project, ToolAutoRunModeItem item) {
        if (Cosy.INSTANCE.checkCosy(project)) {
            GlobalWebToolsAutoExecuteConfig config = new GlobalWebToolsAutoExecuteConfig();
            config.setWebToolsExecutionMode(ToolAutoRunChooser.ITEM_ENABLE_AUTO_RUN == item ? WebToolsExecutionModeEnum.AUTO_EXECUTE.getType() : WebToolsExecutionModeEnum.ASK_EVERY_TIME.getType());
            Cosy.INSTANCE.getLanguageService(project).updateGlobalWebToolsAutoExecute(config, 2000L);
            return true;
        }
        return false;
    }

    public void updateToolRunTipText(JLabel label) {
    }
}

