/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context.aidev;

import com.alibabacloud.intellij.cosy.chat.context.aidev.AIDevFileContextProvider;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileChangedTypeEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileStatusEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileUsageEnum;
import com.alibabacloud.intellij.cosy.editor.FileDiffItemRequest;
import com.alibabacloud.intellij.cosy.editor.InlineDiffManager;
import com.alibabacloud.intellij.cosy.ui.chat.AIDevFilePanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.SnapshotStatusEnum;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.IconUtil;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicLabelUI;

public abstract class BaseAIDevFileContextProvider
implements AIDevFileContextProvider {
    @Override
    public void handleDefaultStatus(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        Color background = this.getBackgroundColor(listPanel, itemPanel);
        SwingUtil.foreachChildComponent(itemPanel, cp -> {
            cp.setBackground(background);
            cp.setForeground("file_name_label".equals(cp.getName()) && null != itemPanel.getFileItem().getChangedType() ? itemPanel.getFileItem().getChangedType().getFileNameForegroundColor() : ColorUtil.getAuxiliaryForegroundColor());
        });
        itemPanel.getChangedLinesLabel().setVisible(false);
        itemPanel.getFileChangedTypeLabel().setVisible(false);
        itemPanel.getAcceptLabel().setVisible(false);
        itemPanel.getRejectLabel().setVisible(false);
        itemPanel.getRightPanel().removeAll();
        AIDevFilePanel.FileItem item = itemPanel.getFileItem();
        itemPanel.getFileStatusLabel().setIcon(this.getIcon());
        itemPanel.getFileStatusLabel().setForeground(ColorUtil.getAuxiliaryForegroundColor());
        itemPanel.getFileStatusLabel().setText(this.getStatus().getName());
        itemPanel.getFileStatusLabel().setVisible(true);
        itemPanel.getRightPanel().add(itemPanel.getFileStatusLabel());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)item.getMessage())) {
            itemPanel.getRightPanel().add(Box.createHorizontalStrut(8));
            itemPanel.getFileMessageLabel().setVisible(true);
            itemPanel.getFileMessageLabel().setToolTipText(item.getMessage());
            itemPanel.getRightPanel().add(itemPanel.getFileMessageLabel());
        }
        itemPanel.getRightPanel().setVisible(AIDevFileUsageEnum.WORKING_SPACE != itemPanel.getUsage() || item.getSnapshot() == null || !SnapshotStatusEnum.OUTDATED.getId().equals(item.getSnapshot().getStatus()));
        this.processFileNameLabel(itemPanel);
    }

    @Override
    public void handleFileNameArea(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        AIDevFilePanel.FileItem item = itemPanel.getFileItem();
        String fileName = item.getName();
        int maxWidth = listPanel.getWidth() - 24 - 16 - 100;
        if (maxWidth > 0) {
            Dimension preferredSize = itemPanel.getFileNameLabel().getPreferredSize();
            if (fileName.length() > maxWidth) {
                fileName = StringUtils.truncateMiddle(fileName, maxWidth);
                itemPanel.getFileNameLabel().setPreferredSize(new Dimension(maxWidth, preferredSize.height));
            } else {
                itemPanel.getFileNameLabel().setPreferredSize(new Dimension(maxWidth, preferredSize.height));
            }
        }
        itemPanel.getFileNameLabel().setText(fileName);
        itemPanel.getFileNameLabel().setIcon(IconUtil.getFileTypeIcon(itemPanel.getProject(), item.getFileId()));
    }

    @Override
    public void handleFileHovering(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        SwingUtil.foreachChildComponent(itemPanel, cp -> {
            cp.setBackground(AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage() ? ColorUtil.getEditorBackgroundColor() : this.getBackgroundColorForSelection(listPanel, itemPanel));
            cp.setForeground(ColorUtil.getTextForegroundColor());
        });
        itemPanel.getRightPanel().removeAll();
        AIDevFilePanel.FileItem item = itemPanel.getFileItem();
        itemPanel.getFileStatusLabel().setIcon(this.getIcon());
        itemPanel.getFileStatusLabel().setText(this.getStatus().getName());
        itemPanel.getFileStatusLabel().setVisible(true);
        itemPanel.getRightPanel().add(itemPanel.getFileStatusLabel());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)item.getMessage())) {
            itemPanel.getRightPanel().add(Box.createHorizontalStrut(8));
            itemPanel.getFileMessageLabel().setVisible(true);
            itemPanel.getFileMessageLabel().setToolTipText(item.getMessage());
            itemPanel.getRightPanel().add(itemPanel.getFileMessageLabel());
        }
        this.processFileNameLabel(itemPanel);
    }

    @Override
    public void handleFileClicking(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        AIDevFilePanel.FileItem item = itemPanel.getFileItem();
        if (AIDevFileUsageEnum.CHAT_CARD == itemPanel.getUsage() || AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage()) {
            SwingUtilities.invokeLater(() -> InlineDiffManager.Companion.getInstance().showSingleDiff(itemPanel.getProject(), new FileDiffItemRequest("DEFAULT_DIFF_TAB_SNAPSHOT_ID", item.getName(), item.getPath(), item.getId(), item.getStatus(), null, true, item.getAddedLines(), item.getAddedChars())));
        } else {
            InlineDiffManager.Companion.getInstance().showMultipleDiff(itemPanel.getProject(), item.getSnapshot().getId(), null, item.getId(), false, false, true);
        }
    }

    @Override
    public Color getBackgroundColorForSelection(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        return ColorUtil.getItemSelectionBackground();
    }

    @Override
    public Color getBackgroundColor(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        return AIDevFileUsageEnum.CHAT_CARD == itemPanel.getUsage() || AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage() ? ColorUtil.getToolWindowBackgroundColor() : ColorUtil.getEditorBackgroundColor();
    }

    public abstract AIDevFileStatusEnum getStatus();

    public Icon getIcon() {
        return null;
    }

    protected void processFileNameLabel(AIDevFilePanel.FileItemPanel itemPanel) {
        if (AIDevFileChangedTypeEnum.DELETE == itemPanel.getFileItem().getChangedType()) {
            JLabel nameLabel = itemPanel.getFileNameLabel();
            nameLabel.setForeground(itemPanel.getFileItem().getChangedType().getFileNameForegroundColor());
            BaseAIDevFileContextProvider.applyStrikeThrough(nameLabel);
        }
    }

    protected void constructChangeLinesAndTypeLabel(AIDevFilePanel.FileItemPanel itemPanel) {
        AIDevFilePanel.FileItem item = itemPanel.getFileItem();
        StringBuilder sb = new StringBuilder();
        if (item.getLastAddedLines() > 0) {
            sb.append("+").append(item.getLastAddedLines());
        }
        if (item.getLastDeletedLines() > 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("-").append(item.getLastDeletedLines());
        }
        if (sb.length() > 0) {
            itemPanel.getChangedLinesLabel().setText(sb.toString());
            itemPanel.getChangedLinesLabel().setForeground(ColorUtil.getAuxiliaryForegroundColor());
        }
        itemPanel.getFileChangedTypeLabel().setText(item.getChangedType().getName());
        itemPanel.getFileChangedTypeLabel().setForeground(item.getChangedType().getColor());
        itemPanel.getRightPanel().add(Box.createHorizontalStrut(16), 0);
        itemPanel.getRightPanel().add((Component)itemPanel.getFileChangedTypeLabel(), 0);
        itemPanel.getRightPanel().add(Box.createHorizontalStrut(16), 0);
        itemPanel.getRightPanel().add((Component)itemPanel.getChangedLinesLabel(), 0);
        itemPanel.getChangedLinesLabel().setVisible(true);
        itemPanel.getFileChangedTypeLabel().setVisible(true);
    }

    public static void applyStrikeThrough(JLabel nameLabel) {
        nameLabel.putClientProperty("strike.through", Boolean.TRUE);
        nameLabel.setUI(new BasicLabelUI(){

            @Override
            public void paint(Graphics g, JComponent c) {
                JLabel label;
                String text;
                super.paint(g, c);
                if (Boolean.TRUE.equals(c.getClientProperty("strike.through")) && (text = (label = (JLabel)c).getText()) != null && !text.isEmpty()) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setColor(c.getForeground());
                    FontMetrics fm = g2d.getFontMetrics();
                    int textX = 0;
                    Icon icon = label.getIcon();
                    if (icon != null) {
                        textX = icon.getIconWidth() + label.getIconTextGap();
                    }
                    int textWidth = fm.stringWidth(text);
                    int strikeY = c.getHeight() / 2;
                    g2d.drawLine(textX, strikeY, textX + textWidth, strikeY);
                    g2d.dispose();
                }
            }
        });
    }

    protected void addOperationLabel(AIDevFilePanel.FileItemPanel itemPanel) {
        Color labelColor = ColorUtil.getLinkForegroundColor();
        JLabel rejectLabel = itemPanel.getRejectLabel();
        rejectLabel.setForeground(labelColor);
        rejectLabel.setVisible(true);
        JLabel acceptLabel = itemPanel.getAcceptLabel();
        acceptLabel.setForeground(labelColor);
        acceptLabel.setVisible(true);
        itemPanel.getRightPanel().add(itemPanel.getRejectLabel());
        itemPanel.getRightPanel().add(Box.createHorizontalStrut(12));
        itemPanel.getRightPanel().add(itemPanel.getAcceptLabel());
    }
}

