/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context.aidev;

import com.alibabacloud.intellij.cosy.chat.context.aidev.BaseAIDevFileContextProvider;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileStatusEnum;
import com.alibabacloud.intellij.cosy.chat.enums.aidev.AIDevFileUsageEnum;
import com.alibabacloud.intellij.cosy.editor.InlineDiffManager;
import com.alibabacloud.intellij.cosy.ui.chat.AIDevFilePanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.SnapshotStatusEnum;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.JPanel;

public class AppliedFileContextProvider
extends BaseAIDevFileContextProvider {
    @Override
    public void handleDefaultStatus(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        AIDevFilePanel.FileItem item = itemPanel.getFileItem();
        if (AIDevFileUsageEnum.CHAT_CARD == itemPanel.getUsage() || AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage()) {
            super.handleDefaultStatus(listPanel, itemPanel);
            this.constructChangeLinesAndTypeLabel(itemPanel);
        } else {
            itemPanel.getRightPanel().removeAll();
            itemPanel.setBackground(this.getBackgroundColor(listPanel, itemPanel));
            itemPanel.getFileStatusLabel().setVisible(false);
            itemPanel.getFileMessageLabel().setVisible(false);
            itemPanel.getFileVersionLabel().setVisible(false);
            StringBuilder sb = new StringBuilder();
            if (item.getAddedLines() > 0) {
                sb.append("+").append(item.getAddedLines());
            }
            if (item.getDeletedLines() > 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("-").append(item.getDeletedLines());
            }
            if (sb.length() > 0) {
                itemPanel.getChangedLinesLabel().setText(sb.toString());
                itemPanel.getChangedLinesLabel().setForeground(ColorUtil.getAuxiliaryForegroundColor());
            }
            itemPanel.getFileChangedTypeLabel().setText(item.getChangedType().getName());
            itemPanel.getFileChangedTypeLabel().setForeground(item.getChangedType().getColor());
            itemPanel.getChangedLinesLabel().setVisible(true);
            itemPanel.getFileChangedTypeLabel().setVisible(true);
            itemPanel.getRightPanel().add(itemPanel.getChangedLinesLabel());
            itemPanel.getRightPanel().add(Box.createHorizontalStrut(8));
            itemPanel.getRightPanel().add(itemPanel.getFileChangedTypeLabel());
            itemPanel.getRightPanel().setBackground(ColorUtil.getEditorBackgroundColor());
            itemPanel.getRightPanel().setVisible(AIDevFileUsageEnum.WORKING_SPACE != itemPanel.getUsage() || item.getSnapshot() == null || !SnapshotStatusEnum.OUTDATED.getId().equals(item.getSnapshot().getStatus()));
        }
    }

    @Override
    public void handleFileHovering(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        AIDevFilePanel.FileItem item = itemPanel.getFileItem();
        if (AIDevFileUsageEnum.CHAT_CARD == itemPanel.getUsage() || AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage()) {
            super.handleFileHovering(listPanel, itemPanel);
            this.constructChangeLinesAndTypeLabel(itemPanel);
        } else if (null == item.getSnapshot() || !item.getSnapshot().isCurrent()) {
            itemPanel.setBackground(super.getBackgroundColorForSelection(listPanel, itemPanel));
            itemPanel.getChangedLinesLabel().setForeground(ColorUtil.getTextForegroundColor());
        } else {
            itemPanel.getRightPanel().removeAll();
            itemPanel.setBackground(this.getBackgroundColorForSelection(listPanel, itemPanel));
            this.addOperationLabel(itemPanel);
        }
    }

    @Override
    public void handleFileClicking(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        if (AIDevFileUsageEnum.CHAT_CARD == itemPanel.getUsage() || AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage()) {
            super.handleFileClicking(listPanel, itemPanel);
        } else {
            AIDevFilePanel.FileItem item = itemPanel.getFileItem();
            InlineDiffManager.Companion.getInstance().showMultipleDiff(itemPanel.getProject(), item.getSnapshot().getId(), null, item.getId(), false, AIDevFileUsageEnum.CHAT_CARD == itemPanel.getUsage() || AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage(), true);
        }
    }

    @Override
    public Color getBackgroundColorForSelection(JPanel listPanel, AIDevFilePanel.FileItemPanel itemPanel) {
        return AIDevFileUsageEnum.CHAT_CARD == itemPanel.getUsage() || AIDevFileUsageEnum.TOOL_PANEL == itemPanel.getUsage() ? super.getBackgroundColorForSelection(listPanel, itemPanel) : ColorUtil.getToolWindowBackgroundColor();
    }

    @Override
    public AIDevFileStatusEnum getStatus() {
        return AIDevFileStatusEnum.APPLIED;
    }
}

