/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context;

import com.alibabacloud.intellij.cosy.chat.context.ChatContextRefProvider;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GeneralPagingParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.KnowledgeBaseInfo;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.KnowledgeBaseParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.KnowledgeBaseResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.UserInfo;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.intellij.openapi.project.Project;
import icons.LingmaIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TeamDocsChatContextRefProvider
implements ChatContextRefProvider {
    private long page = 1L;

    @Override
    public void setup(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        tagComponent.setIcon(LingmaIcons.TeamDocsGrey16Icon);
    }

    @Override
    public void click(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
    }

    @Override
    public List<SuggestPrompt> listSuggestPrompts(Project project, String query) {
        this.page = 1L;
        return this.doListSuggestPrompts(project, query);
    }

    public List<SuggestPrompt> doListSuggestPrompts(Project project, String query) {
        List<SuggestPrompt> prompts = Collections.emptyList();
        KnowledgeBaseResult result = Cosy.INSTANCE.getLanguageService(project).getKnowledgeBaseList((KnowledgeBaseParams)((KnowledgeBaseParams.KnowledgeBaseParamsBuilder)((KnowledgeBaseParams.KnowledgeBaseParamsBuilder)((GeneralPagingParams.GeneralPagingParamsBuilder)((KnowledgeBaseParams.KnowledgeBaseParamsBuilder)((GeneralPagingParams.GeneralPagingParamsBuilder)((KnowledgeBaseParams.KnowledgeBaseParamsBuilder)KnowledgeBaseParams.builder().requestId(UUID.randomUUID().toString())).sessionId(UUID.randomUUID().toString())).query(StringUtils.isEmpty((CharSequence)query) ? null : query)).state("enable")).page((int)this.page++)).pageSize(30)).build(), 3000L);
        if (null != result && CollectionUtils.isNotEmpty(result.getList())) {
            prompts = result.getList().stream().map(TeamDocsChatContextRefProvider::getSuggestPrompt).collect(Collectors.toList());
        }
        return prompts;
    }

    @NotNull
    public static SuggestPrompt getSuggestPrompt(KnowledgeBaseInfo kb) {
        SuggestPrompt suggestPrompt = new SuggestPrompt(kb.getId(), kb.getName(), Optional.ofNullable(kb.getCreator()).map(UserInfo::getNickName).orElse(""), ChatContextTypeEnum.TEAM_DOCS.getType(), null, "context", false);
        suggestPrompt.setComponentType(ComponentTypeEnum.COMBOBOX.getType());
        suggestPrompt.setContextProvider(InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.TEAM_DOCS.getType()));
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("contextType", ChatContextTypeEnum.TEAM_DOCS.getType());
        suggestPrompt.setExtra(extra);
        SuggestPrompt suggestPrompt2 = suggestPrompt;
        if (suggestPrompt2 == null) {
            TeamDocsChatContextRefProvider.$$$reportNull$$$0(0);
        }
        return suggestPrompt2;
    }

    @Override
    public Icon getIconOfSuggestPrompt(Project project, SuggestPrompt suggestPrompt) {
        return LingmaIcons.TeamDocsGrey16Icon;
    }

    @Override
    public void clickFromMarkdownPanel(Project project, ChatContextTag tag, JComponent component) {
    }

    @Override
    public List<SuggestPrompt> getRollingUpdateSuggestPrompts(Project project, String query) {
        return this.doListSuggestPrompts(project, query);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/chat/context/TeamDocsChatContextRefProvider", "getSuggestPrompt"));
    }
}

