/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context;

import com.alibabacloud.intellij.cosy.chat.context.ChatContextRefProvider;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ComboBoxItem;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GetComboBoxItemParams;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.intellij.openapi.project.Project;
import icons.LingmaIcons;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class RuleChatContextRefProvider
implements ChatContextRefProvider {
    @Override
    public void setup(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        tagComponent.setIcon(LingmaIcons.RulesGrey16Icon);
    }

    @Override
    public void click(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        String filePath = tag.getFilePath();
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            EditorUtil.openEditorFile(project, filePath, null, tagComponent);
        }
    }

    @Override
    public List<SuggestPrompt> listSuggestPrompts(Project project, String query) {
        SuggestPrompt contextProvider = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.RULE.getType());
        return this.getComboBoxItems(project, query, contextProvider).stream().map(comboBoxItem -> RuleChatContextRefProvider.getSuggestPrompt(comboBoxItem, contextProvider, project)).collect(Collectors.toList());
    }

    @Override
    public Icon getIconOfSuggestPrompt(Project project, SuggestPrompt suggestPrompt) {
        return LingmaIcons.RulesGrey16Icon;
    }

    @Override
    public void clickFromMarkdownPanel(Project project, ChatContextTag tag, JComponent component) {
    }

    private List<ComboBoxItem> getComboBoxItems(Project project, String query, SuggestPrompt contextProvider) {
        if (contextProvider == null) {
            return Collections.emptyList();
        }
        GetComboBoxItemParams comboBoxItemParams = new GetComboBoxItemParams();
        comboBoxItemParams.setIdentifier(contextProvider.getId());
        comboBoxItemParams.setRequestId(UUID.randomUUID().toString());
        comboBoxItemParams.setQuery(query);
        return Cosy.INSTANCE.getLanguageService(project).loadComboBoxItems(comboBoxItemParams, 3000);
    }

    @NotNull
    public static SuggestPrompt getSuggestPrompt(ComboBoxItem rule, SuggestPrompt contextProvider, Project project) {
        String[] split = rule.getName().split(Pattern.quote(File.separator));
        SuggestPrompt suggestPrompt = new SuggestPrompt(rule.getIdentifier(), split[split.length - 1], StringUtils.replace((String)rule.getDisplayName(), (String)project.getPresentableUrl(), (String)""), ChatContextTypeEnum.RULE.getType(), null, "context", false);
        suggestPrompt.setComponentType(ComponentTypeEnum.COMBOBOX.getType());
        suggestPrompt.setContextProvider(contextProvider);
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("contextType", ChatContextTypeEnum.RULE.getType());
        extra.put("filePath", rule.getIdentifier());
        suggestPrompt.setExtra(extra);
        SuggestPrompt suggestPrompt2 = suggestPrompt;
        if (suggestPrompt2 == null) {
            RuleChatContextRefProvider.$$$reportNull$$$0(0);
        }
        return suggestPrompt2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/chat/context/RuleChatContextRefProvider", "getSuggestPrompt"));
    }
}

