/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context;

import com.alibabacloud.intellij.cosy.chat.context.ChatContextRefProvider;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;

public class OpenFilesContextRefProvider
implements ChatContextRefProvider {
    private static final String CONTEXT_NAME = "openFiles";
    private static final List<String> WHITE_EXT_NAMES = List.of("excalidraw", "csv");

    @Override
    public void setup(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        tagComponent.setIcon(AllIcons.Actions.ListFiles);
    }

    @Override
    public void click(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
    }

    @Override
    public List<SuggestPrompt> listSuggestPrompts(Project project, String query) {
        ArrayList<SuggestPrompt> openFilePrompts = new ArrayList<SuggestPrompt>();
        ArrayList<String> openFileUrls = new ArrayList<String>();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : fileEditorManager.getAllEditors()) {
            VirtualFile openFile = fileEditor.getFile();
            if (openFile == null) continue;
            String extName = openFile.getExtension();
            String fileUrl = openFile.getPresentableUrl();
            if (fileEditor instanceof TextEditor) {
                Editor textEditor = ((TextEditor)fileEditor).getEditor();
                if (openFileUrls.contains(fileUrl)) continue;
                if (fileUrl.startsWith("file://")) {
                    openFilePrompts.add(this.createFilePrompt(project, openFile, null));
                    openFileUrls.add(fileUrl);
                    continue;
                }
                String fileContent = textEditor.getDocument().getText();
                if (fileContent.isEmpty()) continue;
                openFilePrompts.add(this.createFilePrompt(project, openFile, fileContent));
                openFileUrls.add(fileUrl);
                continue;
            }
            if (extName == null || !WHITE_EXT_NAMES.contains(extName)) continue;
            openFilePrompts.add(this.createFilePrompt(project, openFile, null));
            openFileUrls.add(fileUrl);
        }
        return openFilePrompts;
    }

    private SuggestPrompt createFilePrompt(Project project, final VirtualFile openFile, final String fileContent) {
        SuggestPrompt globalSuggestPrompt = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.FILE.getType());
        String fileName = openFile.getName();
        final String extName = openFile.getExtension();
        final String fileUrl = openFile.getPresentableUrl();
        String projectBasePath = project.getBasePath();
        String hint = fileName;
        if (projectBasePath != null && fileUrl.contains(projectBasePath)) {
            hint = StringUtils.replace((String)fileUrl, (String)projectBasePath, (String)"");
        }
        SuggestPrompt fileSuggestPrompt = new SuggestPrompt(fileUrl, fileName, hint, ChatContextTypeEnum.FILE.getType(), null, "context", false);
        fileSuggestPrompt.setType("context");
        fileSuggestPrompt.setComponentType(ComponentTypeEnum.COMBOBOX.getType());
        fileSuggestPrompt.setContextProvider(globalSuggestPrompt);
        fileSuggestPrompt.setExtra((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("contextType", ChatContextTypeEnum.FILE.getType());
                this.put("fileType", openFile.getFileType().getName());
                this.put("filePath", fileUrl);
                if (fileContent != null && !fileContent.isEmpty()) {
                    this.put("contentData", OpenFilesContextRefProvider.this.cleanFileContent(extName, fileContent));
                    String protocol = openFile.getFileSystem().getProtocol();
                    this.put("filePath", protocol + "://" + fileUrl);
                    this.put("protocol", protocol);
                }
            }
        });
        return fileSuggestPrompt;
    }

    public String cleanFileContent(String extName, String fileContent) {
        if (extName != null) {
            int offset;
            String extNameLowerCase = extName.toLowerCase();
            String commentStart = null;
            String commentEnd = null;
            switch (extNameLowerCase) {
                case "java": 
                case "groovy": 
                case "kt": 
                case "scala": 
                case "js": 
                case "cjs": 
                case "mjs": 
                case "jsx": 
                case "ts": 
                case "tsx": 
                case "css": {
                    commentStart = "/*";
                    commentEnd = "*/";
                    break;
                }
                case "dtd": 
                case "html": 
                case "htm": 
                case "vue": 
                case "jspx": 
                case "xml": {
                    commentStart = "<!--";
                    commentEnd = "-->";
                    break;
                }
                case "jsp": {
                    commentStart = "<%--";
                    commentEnd = "%>";
                }
            }
            if (commentStart != null && fileContent.startsWith(commentStart) && (offset = fileContent.indexOf(commentEnd)) > 0) {
                return fileContent.substring(offset + commentEnd.length());
            }
        }
        return fileContent;
    }

    @Override
    public Icon getIconOfSuggestPrompt(Project project, SuggestPrompt suggestPrompt) {
        return null;
    }

    @Override
    public void clickFromMarkdownPanel(Project project, ChatContextTag tag, JComponent component) {
    }

    public static void register() {
        if (!InputConstants.SCOPE_SUGGEST_PROMPT_MAP.containsKey(CONTEXT_NAME)) {
            SuggestPrompt suggestPrompt = new SuggestPrompt(CONTEXT_NAME, "@openFiles", "Open Files", CONTEXT_NAME, null, "context", false);
            suggestPrompt.setComponentType(ComponentTypeEnum.GENERAL.getType());
            suggestPrompt.setSourceType("system");
            HashMap<String, Object> extra = new HashMap<String, Object>();
            extra.put("contextType", CONTEXT_NAME);
            suggestPrompt.setExtra(extra);
            InputConstants.SCOPE_SUGGEST_PROMPT_MAP.put(CONTEXT_NAME, suggestPrompt);
        }
    }
}

