/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context;

import com.alibabacloud.intellij.cosy.chat.context.ChatContextRefProvider;
import com.alibabacloud.intellij.cosy.chat.model.LineRange;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.ComponentTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.IconUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FileChatContextRefProvider
implements ChatContextRefProvider {
    private static final Logger LOG = Logger.getInstance(FileChatContextRefProvider.class);
    private Set<String> renderedFileIds = new HashSet<String>();
    private Queue<VirtualFile> queue = new LinkedList<VirtualFile>();

    @Override
    public void setup(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        Icon icon;
        String filePath = tag.getFilePath();
        if (StringUtils.isNotBlank((CharSequence)filePath) && (icon = IconUtil.getFileTypeIcon(project, filePath)) != null) {
            tagComponent.setIcon(icon);
        }
    }

    @Override
    public void click(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        String filePath = tag.getFilePath();
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            LineRange range = null;
            if (tag.getStatLine() != null && tag.getEndLine() != null) {
                range = LineRange.builder().startLine(tag.getStatLine() - 1).endLine(tag.getEndLine() - 1).build();
            }
            EditorUtil.openEditorFile(project, filePath, range, tagComponent);
        }
    }

    @Override
    public List<SuggestPrompt> listSuggestPrompts(Project project, String query) {
        this.renderedFileIds = new HashSet<String>();
        this.queue = new LinkedList<VirtualFile>();
        SuggestPrompt fileSuggestPrompt = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.FILE.getType());
        return this.listAllFiles(project, query).stream().map(e -> FileChatContextRefProvider.getSuggestPrompt(e, fileSuggestPrompt, project)).collect(Collectors.toList());
    }

    @Override
    public Icon getIconOfSuggestPrompt(Project project, SuggestPrompt suggestPrompt) {
        FutureTask<Icon> task = new FutureTask<Icon>(() -> IconUtil.getFileTypeIcon(project, suggestPrompt.getId()));
        task.run();
        Icon icon = null;
        try {
            icon = (Icon)task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Get file icon failed", (Throwable)e);
        }
        return icon;
    }

    @Override
    public void clickFromMarkdownPanel(Project project, ChatContextTag tag, JComponent component) {
    }

    @NotNull
    public static SuggestPrompt getSuggestPrompt(VirtualFile file, SuggestPrompt fileSuggestPrompt, Project project) {
        SuggestPrompt suggestPrompt = new SuggestPrompt(file.getPresentableUrl(), file.getName(), StringUtils.replace((String)file.getPresentableUrl(), (String)project.getBasePath(), (String)""), ChatContextTypeEnum.FILE.getType(), null, "context", false);
        suggestPrompt.setType("context");
        suggestPrompt.setComponentType(ComponentTypeEnum.COMBOBOX.getType());
        suggestPrompt.setContextProvider(fileSuggestPrompt);
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.put("contextType", ChatContextTypeEnum.FILE.getType());
        extra.put("fileType", file.getFileType().getName());
        suggestPrompt.setExtra(extra);
        SuggestPrompt suggestPrompt2 = suggestPrompt;
        if (suggestPrompt2 == null) {
            FileChatContextRefProvider.$$$reportNull$$$0(0);
        }
        return suggestPrompt2;
    }

    private List<VirtualFile> listAllFiles(Project project, String query) {
        return StringUtils.isEmpty((CharSequence)query) ? this.doListAllFiles(project, null) : this.doListAllFilesWithKeyword(project, query);
    }

    private List<VirtualFile> doListAllFilesWithKeyword(Project project, String query) {
        return this.doListAllFiles(project, query);
    }

    private List<VirtualFile> doListAllFiles(Project project, String query) {
        if (null == project.getBasePath()) {
            return Collections.emptyList();
        }
        VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(project.getBasePath());
        if (rootDir == null || !rootDir.exists()) {
            return Collections.emptyList();
        }
        this.processQuickFiles(project, query);
        return this.searchFiles(project, rootDir, query);
    }

    private void processQuickFiles(Project project, String query) {
        VirtualFile currentFile = this.getCurrentFile(project, query);
        if (currentFile != null) {
            this.queue.add(currentFile);
        }
        this.queue.addAll(this.listOpenedFiles(project, query));
        this.queue.addAll(this.listRecentFiles(project, query));
    }

    private List<VirtualFile> listAllProjectFiles(Project project, String query) {
        return FileUtil.searchVirtualFilesByNamesIgnoringCase(project, query);
    }

    private VirtualFile getCurrentFile(Project project, String query) {
        List<VirtualFile> selectFileList;
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (selectedFiles.length > 0 && !(selectFileList = this.filterFilesByQuery(project, Arrays.asList(selectedFiles), query)).isEmpty()) {
            return selectedFiles[0];
        }
        return null;
    }

    private List<VirtualFile> listOpenedFiles(Project project, String query) {
        VirtualFile[] openFilesArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        return this.filterFilesByQuery(project, Arrays.asList(openFilesArray), query);
    }

    private List<VirtualFile> listRecentFiles(Project project, String query) {
        List<VirtualFile> historyFiles = EditorHistoryManager.getInstance((Project)project).getFileList();
        historyFiles = this.filterFilesByQuery(project, historyFiles, query);
        return historyFiles;
    }

    private void listChildFiles(Project project, String query, VirtualFile parentDir, List<VirtualFile> allChildFiles, int fileCount) {
        if (allChildFiles.size() >= fileCount) {
            return;
        }
        if (!FileUtil.isValidDirectory(parentDir)) {
            return;
        }
        VirtualFile[] childList = parentDir.getChildren();
        if (childList == null || childList.length == 0) {
            return;
        }
        for (VirtualFile child : childList) {
            if (allChildFiles.size() >= fileCount) {
                return;
            }
            if (FileElement.isFileHidden((VirtualFile)child)) continue;
            if (child.isDirectory()) {
                this.listChildFiles(project, query, child, allChildFiles, fileCount);
                continue;
            }
            ArrayList<VirtualFile> childFiles = new ArrayList<VirtualFile>(Arrays.asList(child));
            allChildFiles.addAll(this.filterFilesByQuery(project, childFiles, query));
        }
    }

    private List<VirtualFile> searchFiles(Project project, VirtualFile root, String query) {
        ArrayList<VirtualFile> fileList = new ArrayList<VirtualFile>();
        if (null != root) {
            this.queue.offer(root);
        }
        FutureTask<Void> future = new FutureTask<Void>(() -> {
            while (!this.queue.isEmpty() && (long)fileList.size() < 30L) {
                VirtualFile curFile = this.queue.poll();
                if (null == curFile) continue;
                if (curFile.isDirectory()) {
                    VirtualFile[] childList;
                    for (VirtualFile child : childList = curFile.getChildren()) {
                        if (FileElement.isFileHidden((VirtualFile)child)) continue;
                        if (child.isDirectory()) {
                            if (!FileUtil.isValidDirectory(child) || FileUtil.isRuleDirectory(child)) continue;
                            this.queue.offer(child);
                            continue;
                        }
                        if (this.renderedFileIds.contains(child.getPath())) continue;
                        fileList.addAll(this.filterFilesByQuery(project, Collections.singletonList(child), query));
                        this.renderedFileIds.add(child.getPath());
                    }
                    continue;
                }
                if (this.renderedFileIds.contains(curFile.getPath()) || FileUtil.isRuleDirectory(curFile)) continue;
                fileList.addAll(this.filterFilesByQuery(project, Collections.singletonList(curFile), query));
                this.renderedFileIds.add(curFile.getPath());
            }
            return null;
        });
        try {
            future.run();
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            LOG.warn("search files timeout: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("search files error", (Throwable)e);
        }
        return fileList;
    }

    private List<VirtualFile> filterFilesByQuery(Project project, List<VirtualFile> files, String query) {
        if (CollectionUtils.isEmpty(files)) {
            return files;
        }
        files = files.stream().filter(virtualFile -> {
            if (StringUtils.isNotEmpty((CharSequence)query) && !virtualFile.getName().toLowerCase().contains(query)) {
                return false;
            }
            return FileUtil.isValidProjectFile(project, virtualFile);
        }).collect(Collectors.toList());
        return files;
    }

    public static boolean typeOfFile(String type) {
        return ChatContextTypeEnum.FILE.getType().equals(type) || ChatContextTypeEnum.CURRENT_FILE.getType().equals(type) || ChatContextTypeEnum.SELECTED_CODE.getType().equals(type);
    }

    @Override
    public List<SuggestPrompt> getRollingUpdateSuggestPrompts(Project project, String query) {
        SuggestPrompt fileSuggestPrompt = InputConstants.SCOPE_SUGGEST_PROMPT_MAP.get(ChatContextTypeEnum.FILE.getType());
        return this.searchFiles(project, null, query).stream().map(e -> FileChatContextRefProvider.getSuggestPrompt(e, fileSuggestPrompt, project)).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/chat/context/FileChatContextRefProvider", "getSuggestPrompt"));
    }
}

