/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.context;

import com.alibabacloud.intellij.cosy.chat.context.ChatContextRefProvider;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatContextTagButton;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import icons.LingmaIcons;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class CodeChangesContextRefProvider
implements ChatContextRefProvider {
    private static final Logger LOG = Logger.getInstance(CodeChangesContextRefProvider.class);

    @Override
    public void setup(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        tagComponent.setIcon(LingmaIcons.DiffIcon);
        tagComponent.setText(ChatContextTypeEnum.CODE_CHANGES.getType());
    }

    @Override
    public void click(Project project, ChatContextTag tag, ChatContextTagButton tagComponent) {
        this.openCommitChanges(project, tagComponent);
    }

    @Override
    public List<SuggestPrompt> listSuggestPrompts(Project project, String query) {
        return List.of();
    }

    @Override
    public Icon getIconOfSuggestPrompt(Project project, SuggestPrompt suggestPrompt) {
        return LingmaIcons.DiffIcon;
    }

    private void openCommitChanges(Project project, JComponent component) {
        VcsApplicationSettings vcsApplicationSettings = VcsApplicationSettings.getInstance();
        if (vcsApplicationSettings == null) {
            LOG.warn("vcsApplicationSettings is null");
            return;
        }
        if (vcsApplicationSettings.COMMIT_FROM_LOCAL_CHANGES) {
            ToolWindow codeChangesToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Commit");
            if (codeChangesToolWindow == null) {
                LOG.warn("gitLogToolWindow not exist");
                return;
            }
            codeChangesToolWindow.show();
        } else {
            AnAction checkinProjectAction = ActionManager.getInstance().getAction("CheckinProject");
            if (checkinProjectAction != null) {
                ActionUtil.invokeAction((AnAction)checkinProjectAction, (Component)component, (String)"unknown", (InputEvent)null, (Runnable)null);
            }
        }
    }

    @Override
    public void clickFromMarkdownPanel(Project project, ChatContextTag tag, JComponent component) {
        this.openCommitChanges(project, component);
    }
}

