/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.action;

import com.alibabacloud.intellij.cosy.chat.action.BaseCosySelectGenerationAction;
import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.model.Range;
import com.alibabacloud.intellij.cosy.chat.model.TerminalChatContext;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import icons.CommonIcons;
import org.jetbrains.annotations.NotNull;

public class CosyTerminalFixAction
extends BaseCosySelectGenerationAction {
    public static final int MAX_SELECTION_INFO_LINES = 500;

    @Override
    protected ChatTaskEnum getChatTaskEnum() {
        return ChatTaskEnum.TERMINAL_EXPLAIN_FIX;
    }

    @Override
    protected boolean needCheckCode() {
        return false;
    }

    @Override
    protected TerminalChatContext buildChatContext(Project project, PsiFile psiFile, String content, SelectionModel selectionModel, Range range) {
        String selectedText = selectionModel.getSelectedText();
        return ((TerminalChatContext.TerminalChatContextBuilder)TerminalChatContext.builder().terminalContent(selectedText)).build();
    }

    @Override
    protected boolean checkAndNotifySelectedTextLines(Project project, String text) {
        if (super.getCodeLines(text) > 500) {
            NotificationFactory.showInfoNotification(project, String.format(I18NConstant.TERMINAL_NOTIFY_SELECTION_LINE_EXCEED, 500));
            return true;
        }
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CosyTerminalFixAction.$$$reportNull$$$0(0);
        }
        String text = CosyBundle.message("terminal.explain.errors", new Object[0]);
        e.getPresentation().setText(text);
        e.getPresentation().setIcon(CommonIcons.AI);
    }

    @Override
    protected Boolean needClearContext(String chatTask) {
        return CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/cosy/chat/action/CosyTerminalFixAction", "update"));
    }
}

