/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.action;

import com.alibabacloud.intellij.cosy.chat.model.ChatSessionContext;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.ui.search.Constants;
import com.alibabacloud.intellij.cosy.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaTabChangeNotifier;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.annotations.NotNull;

public class CosySelectionChatAction
extends AnAction {
    private static final Logger log = Logger.getInstance(CosySelectionChatAction.class);

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        Project project;
        if (anActionEvent == null) {
            CosySelectionChatAction.$$$reportNull$$$0(0);
        }
        if (null == (project = anActionEvent.getProject())) {
            log.warn("project is null, ignore CosySelectionChatAction");
            return;
        }
        this.triggerChat(project);
        ((LingmaTabChangeNotifier)project.getMessageBus().syncPublisher(LingmaTabChangeNotifier.CHANGE_MAIN_TAB_NOTIFICATION)).changeTab(this.getTargetTab());
    }

    protected String getTargetTab() {
        return CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false) ? "chat" : "AiAssistantAgent";
    }

    public void triggerChat(Project project) {
        if (project == null) {
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
        if (toolWindow == null) {
            return;
        }
        if (!toolWindow.isVisible()) {
            SearchToolWindowFactory.showToolWindow(project);
        } else {
            ChatSessionContext userData = (ChatSessionContext)ApplicationManager.getApplication().getUserData(CosyKey.CHAT_SESSION_CONTEXT);
            String targetTab = this.getTargetTab();
            if (null != userData && !targetTab.equals(userData.getTabType())) {
                ((LingmaTabChangeNotifier)project.getMessageBus().syncPublisher(LingmaTabChangeNotifier.CHANGE_MAIN_TAB_NOTIFICATION)).changeTab(targetTab);
            } else {
                SearchToolWindowFactory.hideToolWindow(project);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "com/alibabacloud/intellij/cosy/chat/action/CosySelectionChatAction", "actionPerformed"));
    }
}

