/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.action;

import com.alibabacloud.intellij.cosy.chat.model.GenerateCommitMsgParam;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.common.VpcFeature;
import com.alibabacloud.intellij.cosy.constants.ScenarioConstants;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GenerateCommitMsgAnswerParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GenerateCommitMsgFinishParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GenerateCommitMsgResult;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.CosyService;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.AuthStatusUtil;
import com.alibabacloud.intellij.cosy.util.ErrorMessageHandler;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.SettingUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import com.intellij.vcs.log.impl.TimedVcsCommitImpl;
import git4idea.GitCommit;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import icons.CommonIcons;
import icons.LingmaIcons;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CosyCommitMessageGenerationAction
extends AnAction
implements UpdateInBackground {
    private static Logger log = Logger.getInstance(CosyCommitMessageGenerationAction.class);
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static final Long MAX_PATCH_LEN = 70000L;
    private static final int MAX_FILE = 50;
    private static final int COSY_GENERATE_TIMEOUT = 20;
    private static final int MAX_SINGLE_LINE_LEN = 300;
    private CosyService cosyService;
    public static final Map<String, Project> COMMIT_MESSAGE_REQUEST_TO_PROJECT = new ConcurrentHashMap<String, Project>();
    public static final Map<String, String> PROJECT_TO_COMMIT_MESSAGE_REQUEST = new ConcurrentHashMap<String, String>();
    public static final Map<String, CommitMessageInstance> REQUEST_COMMIT_MESSAGE = new ConcurrentHashMap<String, CommitMessageInstance>();
    private final StringBuilder commitMessageBuilder = new StringBuilder();

    public CosyCommitMessageGenerationAction() {
        super(CosyBundle.message("cosy.plugin.simple.name", new Object[0]), "", LingmaIcons.StatusBarLocalIcon);
    }

    public void update(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            CosyCommitMessageGenerationAction.$$$reportNull$$$0(0);
        }
        if (!CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            return;
        }
        List<String> features = new ArrayList<String>();
        features = CosyConfig.getFeature(BuildFeature.VPC_ENABLED_FEATURES.getKey(), features);
        if (CollectionUtils.isNotEmpty(features) && features.contains(VpcFeature.FEATURE_COMMIT_MESSAGE.getFeature())) {
            return;
        }
        anActionEvent.getPresentation().setVisible(false);
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            CosyCommitMessageGenerationAction.$$$reportNull$$$0(1);
        }
        if (CommonIcons.stopIcon.equals(anActionEvent.getPresentation().getIcon())) {
            this.stopAnswer(anActionEvent.getProject(), anActionEvent);
            return;
        }
        anActionEvent.getPresentation().setText(CosyBundle.message("chat.answer.btn.stop", new Object[0]));
        anActionEvent.getPresentation().setIcon(CommonIcons.stopIcon);
        CommitMessage commitMessage = (CommitMessage)VcsDataKeys.COMMIT_MESSAGE_CONTROL.getData(anActionEvent.getDataContext());
        this.chatAsk(anActionEvent.getProject(), commitMessage, anActionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDiff(AnActionEvent anActionEvent) {
        Object workflowHandler = anActionEvent.getDataContext().getData(VcsDataKeys.COMMIT_WORKFLOW_HANDLER);
        if (workflowHandler == null) {
            return new ArrayList<String>();
        }
        ArrayList<Change> changeList = new ArrayList<Change>();
        if (workflowHandler instanceof AbstractCommitWorkflowHandler) {
            List includedChanges = ((AbstractCommitWorkflowHandler)workflowHandler).getUi().getIncludedChanges();
            if (CollectionUtils.isNotEmpty((Collection)includedChanges)) {
                changeList.addAll(includedChanges);
            }
            List filePaths = ((AbstractCommitWorkflowHandler)anActionEvent.getDataContext().getData(VcsDataKeys.COMMIT_WORKFLOW_HANDLER)).getUi().getIncludedUnversionedFiles();
            log.debug("filePaths is " + filePaths + ",size is " + filePaths.size());
            if (CollectionUtils.isNotEmpty((Collection)filePaths)) {
                for (FilePath filePath : filePaths) {
                    Change change = new Change(null, (ContentRevision)new CurrentContentRevision(filePath));
                    changeList.add(change);
                }
            }
        } else {
            return new ArrayList<String>();
        }
        ArrayList<String> totalCommitLines = new ArrayList<String>();
        AtomicLong totalLength = new AtomicLong(0L);
        for (Change change : changeList) {
            try {
                Boolean isValid = this.checkIfValidChange(change);
                if (!BooleanUtils.isTrue((Boolean)isValid)) continue;
                List patches = IdeaTextPatchBuilder.buildPatch((Project)anActionEvent.getProject(), Arrays.asList(change), (Path)Path.of(anActionEvent.getProject().getBasePath(), new String[0]), (boolean)false, (boolean)false);
                if (CollectionUtils.isEmpty((Collection)patches)) {
                    String fileName;
                    String string = change.getAfterRevision() != null ? change.getAfterRevision().getFile().getName() : (fileName = change.getBeforeRevision() != null ? change.getBeforeRevision().getFile().getName() : "");
                    if (StringUtils.isBlank((CharSequence)fileName)) continue;
                    totalCommitLines.add(fileName + " change mod");
                    if (totalLength.get() < MAX_PATCH_LEN && totalCommitLines.size() < 50) continue;
                    break;
                }
                Boolean isValidChange = this.checkIfChangeLengthTooLarge(patches, totalLength);
                if (!BooleanUtils.isTrue((Boolean)isValidChange)) continue;
                try (StringWriter writer = new StringWriter();){
                    UnifiedDiffWriter.write((Project)anActionEvent.getProject(), (Path)ProjectKt.getStateStore((Project)anActionEvent.getProject()).getProjectBasePath(), (Collection)patches, (Writer)writer, (String)"\n", null, List.of());
                    if (StringUtils.isNotBlank((CharSequence)writer.toString())) {
                        totalCommitLines.add(writer.toString());
                    }
                    if (totalCommitLines.size() < 50 && totalLength.get() < MAX_PATCH_LEN) continue;
                    break;
                }
            }
            catch (VcsException e) {
                log.warn("get changeList error", (Throwable)e);
            }
            catch (IOException e) {
                log.warn("get changeList error", (Throwable)e);
            }
        }
        return totalCommitLines;
    }

    private Boolean checkIfValidChange(Change change) {
        ContentRevision contentRevision;
        Boolean isBinary = change.getAfterRevision() != null ? change.getAfterRevision().getFile().getFileType().isBinary() : change.getBeforeRevision().getFile().getFileType().isBinary();
        if (isBinary.booleanValue()) {
            return false;
        }
        ContentRevision contentRevision2 = contentRevision = change.getAfterRevision() != null ? change.getAfterRevision() : change.getBeforeRevision();
        if (contentRevision == null) {
            return false;
        }
        String content = null;
        try {
            content = contentRevision.getContent();
        }
        catch (VcsException e) {
            log.warn("get content error", (Throwable)e);
        }
        if (StringUtils.isNotBlank((CharSequence)content) && !content.contains("\n") && !content.contains("\r") && content.length() > 300) {
            return false;
        }
        return true;
    }

    private Boolean checkIfChangeLengthTooLarge(List<FilePatch> patches, AtomicLong totalLength) {
        Long lengthOfChange = 0L;
        for (FilePatch patch : patches) {
            PatchHunk patchHunk;
            if (!(patch instanceof TextFilePatch)) {
                return false;
            }
            List patchHunks = ((TextFilePatch)patch).getHunks();
            if (CollectionUtils.isEmpty((Collection)patchHunks)) {
                return false;
            }
            if (patchHunks.size() == 1 && (patchHunk = (PatchHunk)patchHunks.get(0)).getLines().size() == 1 && patchHunk.getText().length() > 300) {
                return false;
            }
            for (PatchHunk patchHunk2 : patchHunks) {
                lengthOfChange = lengthOfChange + (long)patchHunk2.getText().length();
            }
        }
        if (totalLength.get() + lengthOfChange > MAX_PATCH_LEN) {
            return false;
        }
        totalLength.addAndGet(lengthOfChange);
        return true;
    }

    private void chatAsk(final Project project, final CommitMessage commitMessage, final AnActionEvent anActionEvent) {
        this.commitMessageBuilder.setLength(0);
        final String requestId = UUID.randomUUID().toString();
        this.initGlobalVariable(project, requestId, commitMessage, anActionEvent);
        TelemetryService.getInstance().telemetryGenerateCommitMsg(project, TrackEventTypeEnum.COMMIT_MESSAGE_TRIGGER, requestId);
        new Task.Backgroundable(project, I18NConstant.GENERATE_TIP){
            private boolean success;
            {
                super(project3, title);
                this.success = false;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CosyCommitMessageGenerationAction.this.doChatAsk(project, requestId, commitMessage, anActionEvent);
                }
                catch (Exception e) {
                    CosyCommitMessageGenerationAction.this.afterGenerateCommitMsg(anActionEvent, project, requestId);
                    log.warn("generate commit message, errorMsg is " + e.getMessage());
                }
                this.success = true;
            }

            public void onFinished() {
                if (this.success) {
                    // empty if block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/cosy/chat/action/CosyCommitMessageGenerationAction$1", "run"));
            }
        }.queue();
        this.scheduleChatTimeout(requestId, project, anActionEvent);
    }

    private void doChatAsk(Project project, String requestId, CommitMessage commitMessage, AnActionEvent anActionEvent) {
        if (this.cosyService == null) {
            this.cosyService = new CosyServiceImpl();
        }
        if (!Cosy.INSTANCE.checkCosy(project, true)) {
            ApplicationManager.getApplication().invokeLater(() -> NotificationFactory.showWarnNotification(project, I18NConstant.COSY_RESTARTING));
            this.afterGenerateCommitMsg(anActionEvent, project, requestId);
            return;
        }
        AuthStatus status = LoginUtil.getAuthStatus(project);
        if (status != null && !status.isAllow()) {
            if (AuthStatusUtil.isNotLogin(status)) {
                log.warn("Not login when chatting, show welcome panel");
                if (!UserAuthService.getInstance().requireLogin(project)) {
                    this.afterGenerateCommitMsg(anActionEvent, project, requestId);
                    return;
                }
            }
            String message = AuthStatusUtil.generateAuthMessage(status);
            log.warn("Login status not allowed");
            if (StringUtils.isNotBlank((CharSequence)message)) {
                ApplicationManager.getApplication().invokeLater(() -> NotificationFactory.showWarnNotification(project, message));
            }
            this.afterGenerateCommitMsg(anActionEvent, project, requestId);
            return;
        }
        SwingUtilities.invokeLater(() -> {
            commitMessage.setText("");
            anActionEvent.getPresentation().setIcon(CommonIcons.stopIcon);
            anActionEvent.getPresentation().setText(CosyBundle.message("chat.answer.btn.stop", new Object[0]));
        });
        GenerateCommitMsgParam generateCommitMsgParam = new GenerateCommitMsgParam();
        generateCommitMsgParam.setRequestId(requestId);
        generateCommitMsgParam.setStream(true);
        List<String> commitMessages = this.getLatestCommitMessages(anActionEvent.getProject());
        ApplicationManager.getApplication().invokeLater(() -> {
            List<String> diffList = this.getDiff(anActionEvent);
            if (CollectionUtils.isEmpty(diffList)) {
                NotificationFactory.showWarnNotification(project, CosyBundle.message("commit.message.invalid.hint", new Object[0]));
                this.afterGenerateCommitMsg(anActionEvent, project, requestId);
                return;
            }
            generateCommitMsgParam.setCommitMessages(commitMessages);
            generateCommitMsgParam.setCodeDiffs(diffList);
            generateCommitMsgParam.setPreferredLanguage(SettingUtil.getPreferredLanguage());
            ThreadUtil.execute(() -> {
                GenerateCommitMsgResult generateCommitMsgResult = Cosy.INSTANCE.getLanguageService(project).generateCommitMsg(generateCommitMsgParam, 10000L);
                if (generateCommitMsgResult != null && BooleanUtils.isTrue((Boolean)generateCommitMsgResult.getIsSuccess())) {
                    log.info(String.format("generate commit message result = %s", generateCommitMsgResult.getIsSuccess()));
                } else {
                    log.warn("generate commit message error, requestId is " + requestId + ", result is " + generateCommitMsgResult);
                    this.afterGenerateCommitMsg(anActionEvent, project, requestId);
                }
            });
        }, ModalityState.defaultModalityState());
    }

    private void initGlobalVariable(Project project, String requestId, CommitMessage commitMessage, AnActionEvent anActionEvent) {
        String curRequestId = PROJECT_TO_COMMIT_MESSAGE_REQUEST.get(project.getName());
        if (curRequestId != null) {
            REQUEST_COMMIT_MESSAGE.remove(curRequestId);
            COMMIT_MESSAGE_REQUEST_TO_PROJECT.remove(curRequestId);
            PROJECT_TO_COMMIT_MESSAGE_REQUEST.remove(project.getName());
        }
        COMMIT_MESSAGE_REQUEST_TO_PROJECT.put(requestId, project);
        PROJECT_TO_COMMIT_MESSAGE_REQUEST.put(project.getName(), requestId);
        CommitMessageInstance commitMessageInstance = new CommitMessageInstance(commitMessage, anActionEvent);
        REQUEST_COMMIT_MESSAGE.put(requestId, commitMessageInstance);
    }

    public Boolean updateAnswer(GenerateCommitMsgAnswerParams generateCommitMsgAnswerParams) {
        if (generateCommitMsgAnswerParams == null || generateCommitMsgAnswerParams.getText() == null) {
            log.warn("commit message answer params contain null.");
            return false;
        }
        this.commitMessageBuilder.append(generateCommitMsgAnswerParams.getText());
        ThreadUtil.execute(() -> {
            CommitMessageInstance commitMessageInstance = REQUEST_COMMIT_MESSAGE.get(generateCommitMsgAnswerParams.getRequestId());
            if (commitMessageInstance == null) {
                log.debug("commit message commitMessageInstance null.");
                return;
            }
            Project project = COMMIT_MESSAGE_REQUEST_TO_PROJECT.get(generateCommitMsgAnswerParams.getRequestId());
            CommitMessage commitMessage = commitMessageInstance.getCommitMessage();
            if (project == null || commitMessage == null) {
                log.debug("Cannot find project in commit message processor by request_id " + generateCommitMsgAnswerParams.getRequestId());
                return;
            }
            try {
                SwingUtilities.invokeAndWait(() -> commitMessage.setText(this.commitMessageBuilder.toString()));
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
        return true;
    }

    private void scheduleChatTimeout(String requestId, Project project, AnActionEvent anActionEvent) {
        SCHEDULED_EXECUTOR.schedule(() -> {
            if (COMMIT_MESSAGE_REQUEST_TO_PROJECT.get(requestId) == null) {
                return;
            }
            CommitMessageInstance commitMessageInstance = REQUEST_COMMIT_MESSAGE.get(requestId);
            if (commitMessageInstance == null) {
                return;
            }
            CommitMessage commitMessage = commitMessageInstance.getCommitMessage();
            if (commitMessage != null && StringUtils.isBlank((CharSequence)commitMessage.getText())) {
                NotificationFactory.showWarnNotification(project, I18NConstant.CHAT_ANSWER_TIMEOUT);
                this.afterGenerateCommitMsg(anActionEvent, project, requestId);
            }
        }, 20L, TimeUnit.SECONDS);
    }

    private void stopAnswer(Project project, AnActionEvent anActionEvent) {
        anActionEvent.getPresentation().setText(CosyBundle.message("cosy.plugin.simple.name", new Object[0]));
        anActionEvent.getPresentation().setIcon(LingmaIcons.StatusBarLocalIcon);
        String requestId = PROJECT_TO_COMMIT_MESSAGE_REQUEST.get(project.getName());
        if (requestId == null) {
            return;
        }
        TelemetryService.getInstance().telemetryGenerateCommitMsg(project, TrackEventTypeEnum.COMMIT_MESSAGE_STOP, requestId);
        this.afterGenerateCommitMsg(anActionEvent, project, requestId);
    }

    public Boolean finishAnswer(GenerateCommitMsgFinishParams generateCommitMsgFinishParams) {
        Project project = COMMIT_MESSAGE_REQUEST_TO_PROJECT.get(generateCommitMsgFinishParams.getRequestId());
        if (project == null) {
            log.debug("commit message project null.");
            return false;
        }
        CommitMessageInstance commitMessageInstance = REQUEST_COMMIT_MESSAGE.get(generateCommitMsgFinishParams.getRequestId());
        if (commitMessageInstance == null) {
            log.debug("commit message commitMessageInstance null.");
            return false;
        }
        AnActionEvent anActionEvent = commitMessageInstance.getAnActionEvent();
        if (generateCommitMsgFinishParams.getStatusCode() == 408) {
            NotificationFactory.showWarnNotification(project, I18NConstant.CHAT_ANSWER_TIMEOUT);
        } else if (generateCommitMsgFinishParams.getStatusCode() == 403) {
            String errorMsg = ErrorMessageHandler.convertErrorMessage(project, generateCommitMsgFinishParams.getRequestId(), generateCommitMsgFinishParams.getReason(), ScenarioConstants.SCENARIO_GENERATE_COMMIT_MSG);
            NotificationFactory.showWarnNotification(project, errorMsg);
        }
        this.afterGenerateCommitMsg(anActionEvent, project, generateCommitMsgFinishParams.getRequestId());
        return true;
    }

    private void afterGenerateCommitMsg(AnActionEvent anActionEvent, Project project, String requestId) {
        COMMIT_MESSAGE_REQUEST_TO_PROJECT.remove(requestId);
        REQUEST_COMMIT_MESSAGE.remove(requestId);
        PROJECT_TO_COMMIT_MESSAGE_REQUEST.remove(project.getName());
        if (anActionEvent != null) {
            SwingUtilities.invokeLater(() -> {
                anActionEvent.getPresentation().setText(CosyBundle.message("cosy.plugin.simple.name", new Object[0]));
                anActionEvent.getPresentation().setIcon(LingmaIcons.StatusBarLocalIcon);
            });
        }
    }

    private List<String> getLatestCommitMessages(Project project) {
        VirtualFile[] selectedFiles;
        ArrayList<String> commitMessageList = new ArrayList<String>();
        VirtualFile projectFile = project.getProjectFile();
        if (projectFile == null && (selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles()) != null && selectedFiles.length > 0) {
            projectFile = selectedFiles[0];
        }
        GitRepository repository = null;
        if (projectFile != null) {
            repository = (GitRepository)GitRepositoryManager.getInstance((Project)project).getRepositoryForFile(projectFile);
        } else {
            List repositories = GitRepositoryManager.getInstance((Project)project).getRepositories();
            if (CollectionUtils.isNotEmpty((Collection)repositories)) {
                repository = (GitRepository)repositories.get(0);
            }
        }
        if (repository == null) {
            return commitMessageList;
        }
        VirtualFile root = repository.getRoot();
        if (root == null) {
            return commitMessageList;
        }
        try {
            List commits = GitHistoryUtils.history((Project)project, (VirtualFile)root, (String[])new String[]{"--max-count=3"});
            if (CollectionUtils.isEmpty((Collection)commits)) {
                return commitMessageList;
            }
            commits = commits.stream().sorted(Comparator.comparing(TimedVcsCommitImpl::getTimestamp).reversed()).limit(3L).collect(Collectors.toList());
            for (GitCommit commit : commits) {
                String commitMessage = commit.getFullMessage();
                commitMessageList.add(commitMessage);
            }
        }
        catch (VcsException e) {
            log.warn("getLatestCommitMessages error, errorMsg is " + e.getMessage());
        }
        return commitMessageList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "anActionEvent";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/chat/action/CosyCommitMessageGenerationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class CommitMessageInstance {
        private CommitMessage commitMessage;
        private AnActionEvent anActionEvent;

        public CommitMessageInstance() {
        }

        public CommitMessageInstance(CommitMessage commitMessage, AnActionEvent anActionEvent) {
            this.commitMessage = commitMessage;
            this.anActionEvent = anActionEvent;
        }

        @Generated
        public CommitMessage getCommitMessage() {
            return this.commitMessage;
        }

        @Generated
        public AnActionEvent getAnActionEvent() {
            return this.anActionEvent;
        }

        @Generated
        public void setCommitMessage(CommitMessage commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Generated
        public void setAnActionEvent(AnActionEvent anActionEvent) {
            this.anActionEvent = anActionEvent;
        }
    }
}

