/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.action;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.enums.TaskDefinitionTypeEnum;
import com.alibabacloud.intellij.cosy.chat.enums.TriggerPlaceEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.ChatContext;
import com.alibabacloud.intellij.cosy.chat.model.Position;
import com.alibabacloud.intellij.cosy.chat.model.Range;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.Constants;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.LingmaToolWindowPanel;
import com.alibabacloud.intellij.cosy.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.model.inputextra.ChatTaskExtra;
import com.alibabacloud.intellij.cosy.ui.search.model.tag.TaskChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnyGenerateNotifier;
import com.alibabacloud.intellij.cosy.util.AuthStatusUtil;
import com.alibabacloud.intellij.cosy.util.ChatSessionUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import icons.CommonIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCosySelectGenerationAction
extends AnAction
implements UpdateInBackground {
    private static Logger log = Logger.getInstance(BaseCosySelectGenerationAction.class);
    public static final int MAX_SELECTION_CODE_LINES = 1000;
    public static Map<String, TrackEventTypeEnum> PLACE_EVENT_TYPE_MAPPING = new HashMap<String, TrackEventTypeEnum>(){
        private static final long serialVersionUID = 4215657320805394643L;
        {
            this.put(TriggerPlaceEnum.EDITOR_POPUP.getName(), TrackEventTypeEnum.CHAT_TRIGGER_RIGHT_CLICK);
            this.put(TriggerPlaceEnum.TOOL_WINDOW.getName(), TrackEventTypeEnum.CHAT_TRIGGER_QUICK_BUTTON);
            this.put(TriggerPlaceEnum.MENU_POPUP.getName(), TrackEventTypeEnum.CHAT_TRIGGER_METHOD);
            this.put(TriggerPlaceEnum.ASK_INPUT_PANEL.getName(), TrackEventTypeEnum.CHAT_TRIGGER_ASK_PANEL);
        }
    };

    public void actionPerformed(@NotNull AnActionEvent e) {
        String chatTask;
        ChatContextTag chatContextTag;
        if (e == null) {
            BaseCosySelectGenerationAction.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        Project project = e.getProject();
        if (editor == null && (editor = EditorUtil.getSelectedEditorSafely(project)) == null) {
            NotificationFactory.showInfoNotification(project, CosyBundle.message("chat.ask.editor.empty", new Object[0]));
            return;
        }
        if (project == null) {
            log.error("Cannot find project in BaseCosySelectGenerationAction.");
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        EditorUtil.SelectionModelInfo info = EditorUtil.getSelectionModelInfo(selectionModel);
        String code = info.getSelectedText();
        VisualPosition visualStartPosition = info.getSelectionStartPosition();
        VisualPosition visualEndPosition = info.getSelectionEndPosition();
        Range range = null;
        if (visualStartPosition != null && visualEndPosition != null && StringUtils.isNotEmpty((CharSequence)code)) {
            int startLine = editor.visualToLogicalPosition((VisualPosition)visualStartPosition).line;
            int startCharacter = 0;
            int endLine = editor.visualToLogicalPosition((VisualPosition)visualEndPosition).line;
            int endCharacter = editor.getDocument().getLineEndOffset(endLine) - editor.getDocument().getLineStartOffset(endLine);
            code = editor.getDocument().getText(new TextRange(editor.getDocument().getLineStartOffset(startLine), editor.getDocument().getLineEndOffset(endLine)));
            range = Range.builder().start(Position.builder().line(startLine).character(startCharacter).build()).end(Position.builder().line(endLine).character(endCharacter).build()).build();
        }
        Boolean hasSelectedCode = false;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            hasSelectedCode = true;
        }
        if (this.needCheckCode() && !hasSelectedCode.booleanValue()) {
            NotificationFactory.showInfoNotification(project, I18NConstant.CHAT_NOTIFY_SELECT_CODE);
            return;
        }
        if (this.checkAndNotifySelectedTextLines(project, code)) {
            return;
        }
        ChatContext chatContext = this.buildChatContext(project, psiFile, code, selectionModel, range);
        ChatAskInput chatAskInput = this.getChatAskInput(e);
        if (this.needCheckCode() && chatAskInput.getContextTags().stream().noneMatch(tag -> tag.getStatLine() != null && tag.getActualValid() != false) && (chatContextTag = ChatContextTag.buildFromActiveFileInfo(ActiveFileInfo.getFromEditor(editor))) != null) {
            List<ChatContextTag> contextTags = chatAskInput.getContextTags();
            if (contextTags == null) {
                contextTags = new ArrayList<ChatContextTag>();
            }
            contextTags.add(chatContextTag);
            chatAskInput.setContextTags(contextTags);
        }
        if (!this.checkCommandContext(project, chatContext, chatAskInput, chatTask = this.getChatTask(chatAskInput)).booleanValue()) {
            return;
        }
        GenerateInput genInput = new GenerateInput(this.getQuestion(chatAskInput), chatTask, chatContext, chatAskInput);
        String taskType = this.getTaskDefinitionType();
        genInput.setTaskDefinitionType(taskType);
        genInput.setExtra(this.getExtra(chatAskInput));
        SearchContext context = new SearchContext(OperationEnum.CLEAR_AND_ADD.text, SearchActionTypeEnum.RIGHT_CLICK_TRIGGER.getType());
        SessionTypeEnum sessionType = LingmaToolWindowPanel.getBySessionTab(genInput.getSessionTab());
        String requestId = ChatSessionUtil.getRequestId(sessionType.getType());
        TrackEventTypeEnum eventType = PLACE_EVENT_TYPE_MAPPING.getOrDefault(e.getPlace(), TrackEventTypeEnum.CHAT_TRIGGER_RIGHT_CLICK);
        TelemetryService.getInstance().telemetryChatTask(project, eventType, requestId, chatContext.getSessionId(), chatTask, genInput, sessionType.getTelemetryType());
        CosyCacheKeys.NEED_INIT_WELCOME_WINDOW.set((UserDataHolder)project, (Object)false);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
        if (toolWindow == null) {
            ToolWindowManager.getInstance((Project)project).registerToolWindow(RegisterToolWindowTask.closable((String)Constants.PLUGIN_NAME, (Icon)CommonIcons.AI, (ToolWindowAnchor)ToolWindowAnchor.RIGHT));
            toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
        }
        ToolWindow finalToolWindow = toolWindow;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (finalToolWindow != null) {
                if (finalToolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME) == null) {
                    SearchToolWindowFactory.createSearchMainPanelAndGenerateContentForm(project, finalToolWindow, (Consumer<Project>)((Consumer)project1 -> ((AnyGenerateNotifier)project1.getMessageBus().syncPublisher(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION)).anyGenerate(context, genInput, requestId, this.needClearContext(chatTask))));
                } else {
                    SearchToolWindowFactory.showToolWindow(project);
                    ((AnyGenerateNotifier)project.getMessageBus().syncPublisher(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION)).anyGenerate(context, genInput, requestId, this.needClearContext(chatTask));
                }
            }
        });
    }

    private ChatAskInput getChatAskInput(@NotNull AnActionEvent e) {
        Object askDataObj;
        if (e == null) {
            BaseCosySelectGenerationAction.$$$reportNull$$$0(1);
        }
        ChatAskInput chatAskInput = (askDataObj = e.getDataContext().getData("ask.input")) == null ? null : (ChatAskInput)askDataObj;
        Project project = e.getProject();
        AuthStatus status = LoginUtil.getAuthStatusCacheFirst(project);
        String userId = "";
        if (!AuthStatusUtil.isNotLogin(status)) {
            userId = status.getId();
        }
        if (chatAskInput == null) {
            String chatTask = this.getChatTaskEnum().getName();
            String text = InputConstants.CHAT_TASK_QUERY_MAP.get(chatTask);
            TaskChatAskTag tag = null;
            if (StringUtils.isNotBlank((CharSequence)text)) {
                tag = new TaskChatAskTag(chatTask, text);
            }
            String inputText = null;
            if (chatTask.equals(ChatTaskEnum.TERMINAL_EXPLAIN_FIX.getName())) {
                inputText = CosyBundle.message("terminal.explain.fix.display.prompt", new Object[0]);
            }
            if (tag != null) {
                ChatInputElement tagElement = new ChatInputElement(null, tag, "tag");
                ArrayList<ChatInputElement> elements = new ArrayList<ChatInputElement>();
                elements.add(tagElement);
                if (StringUtils.isNotBlank((CharSequence)inputText)) {
                    ChatInputElement textElement = new ChatInputElement(inputText, null, "text");
                    elements.add(textElement);
                }
                chatAskInput = new ChatAskInput();
                chatAskInput.setChatInputElements(elements);
            } else if (StringUtils.isNotBlank(inputText)) {
                ChatInputElement textElement = new ChatInputElement(inputText, null, "text");
                ArrayList<ChatInputElement> elements = new ArrayList<ChatInputElement>();
                elements.add(textElement);
                chatAskInput = new ChatAskInput();
                chatAskInput.setChatInputElements(elements);
            }
        }
        return chatAskInput;
    }

    protected ChatContext buildChatContext(Project project, PsiFile psiFile, String code, SelectionModel selectionModel, Range range) {
        return ((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)ChatContext.builder().fileLanguage(FileUtil.getLanguageFileType(project))).filePath(psiFile == null || psiFile.getVirtualFile() == null ? null : psiFile.getVirtualFile().getPresentableUrl())).fileCode(psiFile == null ? null : psiFile.getText())).sessionId(null)).range(range)).sourceCode(code)).localeLanguage(Locale.getDefault().getLanguage())).build();
    }

    protected boolean needCheckCode() {
        return true;
    }

    protected boolean checkAndNotifySelectedTextLines(Project project, String code) {
        if (this.getCodeLines(code) > 1000) {
            NotificationFactory.showInfoNotification(project, String.format(I18NConstant.CHAT_NOTIFY_SELECTION_LINE_EXCEED, 1000));
            return true;
        }
        return false;
    }

    private boolean containsCode(Project project, PsiFile psiFile, String code, SelectionModel selectionModel) {
        return PsiUtils.containsCode(project, psiFile, selectionModel);
    }

    protected int getCodeLines(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return 1;
        }
        return code.split("\n").length;
    }

    private String getTaskInputKey(String userId, String chatTask) {
        return userId + ":" + chatTask;
    }

    protected abstract ChatTaskEnum getChatTaskEnum();

    protected String getQuestion(ChatAskInput chatAskInput) {
        return this.getChatTaskEnum().getDisplayText();
    }

    protected String getChatTask(ChatAskInput chatAskInput) {
        return this.getChatTaskEnum().getName();
    }

    protected Boolean checkCommandContext(Project project, ChatContext chatContext, ChatAskInput chatAskInput, String chatTask) {
        return true;
    }

    protected String getTaskDefinitionType() {
        return TaskDefinitionTypeEnum.System_COMMAND.getType();
    }

    protected ChatTaskExtra getExtra(ChatAskInput chatAskInput) {
        return null;
    }

    protected Boolean needClearContext(String chatTask) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/chat/action/BaseCosySelectGenerationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChatAskInput";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

