/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.BinaryManager;
import com.alibabacloud.intellij.cosy.editor.CosyEditorActionHandler;
import com.alibabacloud.intellij.cosy.listener.CosyPluginStateListener;
import com.alibabacloud.intellij.cosy.listener.CosyVirtualFileListener;
import com.alibabacloud.intellij.cosy.search.enums.DocumentOpenModeEnum;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.update.LingmaPluginUpdateChecker;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.jcef.JBCefApp;
import com.jetbrains.cef.JCefAppConfig;
import java.awt.Color;
import java.util.Objects;
import org.cef.CefSettings;

public class CosyLoader
implements ApplicationInitializedListener {
    public static final Logger log = Logger.getInstance(CosyLoader.class);
    private final String[] EDITOR_ACTIONS = new String[]{"EditorEscape", "ExpandLiveTemplateByTab", "NextTemplateVariable", "EditorBackSpace", "EditorEnter", "EditorUp", "EditorDown", "EditorLeft", "EditorRight", "EditorLineStart", "EditorLineEnd", "EditorDelete", "EditorTab", "EditorChooseLookupItemReplace", "ExpandLiveTemplateByTab", "PreviousTemplateVariable", "EditorChooseLookupItem", "Esc", "\u6309 Tab \u5c55\u5f00\u5b9e\u65f6\u6a21\u677f", "\u4e0b\u4e00\u4e2a\u6a21\u677f\u53d8\u91cf\u6216\u5b8c\u6210\u5c31\u5730\u91cd\u6784", "\u9000\u683c", "Enter", "\u4e0a", "\u4e0b", "\u5de6", "\u53f3", "\u4e0b", "\u5c06\u6587\u672c\u5149\u6807\u79fb\u81f3\u884c\u9996", "\u5c06\u6587\u672c\u5149\u6807\u79fb\u81f3\u884c\u5c3e", "\u5220\u9664", "\u6807\u7b7e\u9875", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee\u66ff\u6362", "\u6309 Tab \u5c55\u5f00\u5b9e\u65f6\u6a21\u677f", "\u4e0b\u4e00\u4e2a\u6a21\u677f\u53d8\u91cf\u6216\u5b8c\u6210\u5c31\u5730\u91cd\u6784", "\u4e0a\u4e00\u4e2a\u6a21\u677f\u53d8\u91cf", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee"};

    public void componentsInitialized() {
        PluginInstaller.addStateListener((PluginStateListener)new CosyPluginStateListener());
        new Thread(() -> {
            log.info("Check binary when app starting...");
            BinaryManager.INSTANCE.checkBinary(false);
        }).start();
        LingmaPluginUpdateChecker.delayCheckUpdate();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new CosyVirtualFileListener());
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (!JBCefApp.isSupported() || setting != null && DocumentOpenModeEnum.OPEN_IN_WEB.equals((Object)setting.getDefaultDocumentOpenMode())) {
            return;
        }
        try {
            JCefAppConfig config = JCefAppConfig.getInstance();
            CefSettings cefSettings = config.getCefSettings();
            cefSettings.user_agent = "Mozilla/5.0 (Android 6.0)";
            Color bgColor = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            CefSettings cefSettings2 = cefSettings;
            Objects.requireNonNull(cefSettings2);
            cefSettings.background_color = new CefSettings.ColorType(cefSettings2, bgColor.getAlpha(), bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
        }
        catch (Exception e) {
            log.warn("Unsupported JBCefBrowser:" + e.getMessage());
        }
    }

    private void overrideEditorActions() {
        EditorActionManager editorActionManager = EditorActionManager.getInstance();
        for (String action : this.EDITOR_ACTIONS) {
            AnAction anAction = ActionManager.getInstance().getAction(action);
            if (!(anAction instanceof EditorAction)) {
                log.debug("ignore override action handler:" + action);
                continue;
            }
            EditorAction editorAction = (EditorAction)anAction;
            EditorActionHandler handler = editorAction.getHandler();
            if (handler == null) continue;
            log.debug("override action handler:" + action);
            editorActionManager.setActionHandler(action, (EditorActionHandler)new CosyEditorActionHandler(handler, action));
        }
    }
}

